/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.betterflight.client.gui;

import com.notcharrow.betterflight.client.ClientData;
import com.notcharrow.betterflight.config.CommonConfig;
import com.notcharrow.betterflight.util.InputHandler;
import java.util.Random;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class StaminaHudOverlay {
    private static final int SPRITE_WIDTH = 9;
    private static final int SPRITE_HEIGHT = 9;
    private static final int NONE = 0;
    private static final int FILL_FULL = 9;
    private static final int FILL_HALF = 18;
    private static final int WHITE_OUTLINE = 27;
    private static final int FLARE_OUTLINE = 36;
    private static final int RED_OUTLINE = 45;
    private static final int FULL_DURABILITY = 0;
    private static final int HALF_DURABILITY = 9;
    private static final int QUARTER_DURABILITY = 18;
    private static final int LOW_DURABILITY = 27;
    private static final Random random = new Random(System.currentTimeMillis());
    private static final class_2960 STAMINA_ICONS = class_2960.method_60655((String)"betterflight", (String)"textures/elytraspritesheet.png");
    private static int shakeEffectTimer = 0;
    private static int regenEffectTimer = 0;
    private static int durability;

    public static void init() {
        HudRenderCallback.EVENT.register((context, renderTickCounter) -> {
            if (!ClientData.isFlightEnabled() || !ClientData.isWearingFunctionalWings()) {
                return;
            }
            if (CommonConfig.CONFIG.classicHud) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1724 == null || mc.field_1690.field_1842) {
                return;
            }
            if (mc.field_1724.method_5765()) {
                return;
            }
            StaminaHudOverlay.renderStaminaBar(context, mc);
        });
    }

    private static void renderStaminaBar(class_332 context, class_310 mc) {
        int i;
        int x = mc.method_22683().method_4486() / 2;
        int y = mc.method_22683().method_4502();
        int shakeX = 0;
        int shakeY = 0;
        int rightOffset = 49;
        durability = StaminaHudOverlay.getDurabilityState(ClientData.getElytraDurability());
        if (durability == 27) {
            if (mc.field_1687 != null && !mc.method_1493()) {
                long thisTick = mc.field_1687.method_8510();
                if (shakeEffectTimer > 0) {
                    if (thisTick % 3L == 0L) {
                        shakeX = random.nextInt(2) - 1;
                    } else if (thisTick % 3L == 1L) {
                        shakeY = random.nextInt(2) - 1;
                    }
                    --shakeEffectTimer;
                } else if (thisTick % 20L == 0L) {
                    shakeEffectTimer = 20;
                }
            }
        } else {
            shakeEffectTimer = 0;
        }
        for (i = 0; i < 10; ++i) {
            context.method_25290(STAMINA_ICONS, StaminaHudOverlay.getXPos(x, i) + shakeX, y - rightOffset + shakeY, 0.0f, (float)durability, 9, 9, 256, 256);
        }
        for (i = 0; i < 10; ++i) {
            if (!((double)(i + 1) <= Math.ceil((double)InputHandler.charge / 2.0)) || InputHandler.charge <= 0) continue;
            int type = (double)(i + 1) == Math.ceil((double)InputHandler.charge / 2.0) && InputHandler.charge % 2 != 0 ? 18 : 9;
            context.method_25290(STAMINA_ICONS, StaminaHudOverlay.getXPos(x, i) + shakeX, y - rightOffset + shakeY, (float)type, (float)durability, 9, 9, 256, 256);
        }
        if (ClientData.isFlaring()) {
            StaminaHudOverlay.renderOutline(context, x, y, rightOffset, shakeX, shakeY, 36);
        }
        if (shakeEffectTimer > 0) {
            StaminaHudOverlay.renderOutline(context, x, y, rightOffset, shakeX, shakeY, 45);
        }
        if (regenEffectTimer > 0) {
            StaminaHudOverlay.renderOutline(context, x, y, rightOffset, shakeX, shakeY, 27);
            --regenEffectTimer;
        }
    }

    private static void renderOutline(class_332 context, int x, int y, int rightOffset, int shakeX, int shakeY, int outlineType) {
        for (int i = 0; i < 10; ++i) {
            context.method_25290(STAMINA_ICONS, StaminaHudOverlay.getXPos(x, i) + shakeX, y - rightOffset + shakeY, (float)outlineType, (float)durability, 9, 9, 256, 256);
        }
    }

    private static int getDurabilityState(double durability) {
        if (durability > (double)0.95f) {
            return 27;
        }
        if (durability > 0.75) {
            return 18;
        }
        if (durability > 0.5) {
            return 9;
        }
        return 0;
    }

    private static int getXPos(int x, int i) {
        return x + 90 - (i + 1) * 8;
    }

    public static void startRegenAnimation() {
        if (regenEffectTimer == 0) {
            regenEffectTimer = 10;
        }
    }
}

