/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.betterflight.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.notcharrow.betterflight.BetterFlight;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class CommonConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("betterflight-common.json");
    public static ConfigData CONFIG = new ConfigData();
    public static final double TAKE_OFF_SPEED = 0.17;
    public static final double TAKE_OFF_THRUST = 1.0;
    public static final double CLASSIC_FLAP_THRUST = 0.65;
    public static final double FLARE_DRAG = 0.08;
    public static final int TAKE_OFF_JUMP_DELAY = 4;

    public static void init() {
        CommonConfig.load();
    }

    public static void load() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                CONFIG = (ConfigData)gson.fromJson(json, ConfigData.class);
            }
            catch (IOException e) {
                BetterFlight.LOGGER.error("Failed to load config", (Throwable)e);
                CommonConfig.save();
            }
        } else {
            CommonConfig.save();
        }
    }

    public static void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            String json = gson.toJson((Object)CONFIG);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            BetterFlight.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static class ConfigData {
        public int maxCharge = 20;
        public int takeOffCost = 3;
        public int flapCost = 2;
        public int rechargeTicksInAir = 80;
        public int rechargeTicksOnGround = 10;
        public int flareTicksPerChargePoint = 40;
        public double exhaustionPerChargePoint = 4.0;
        public int minFood = 6;
        public int cooldownTicks = 10;
        public int softCeiling = 256;
        public int hardCeiling = 400;
        public boolean classicMode = false;
        public String hudLocation = "BAR_CENTER";
        public boolean classicHud = false;
    }
}

