/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.betterflight.util;

import com.notcharrow.betterflight.common.FlightActionType;
import com.notcharrow.betterflight.config.CommonConfig;
import com.notcharrow.betterflight.networking.FlightNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public class FlightHandler {
    public static void handleClassicTakeoff(class_1657 player) {
        class_243 upwards = new class_243(0.0, 1.0, 0.0).method_1021(FlightHandler.getCeilingFactor(player));
        player.method_23669();
        player.method_5762(upwards.field_1352, upwards.field_1351, upwards.field_1350);
        FlightNetworking.sendFlightActionToServer(FlightActionType.TAKEOFF);
    }

    public static void handleClassicFlap(class_1657 player) {
        double ceilingFactor = FlightHandler.getCeilingFactor(player);
        class_243 upwards = new class_243(0.0, 0.9750000000000001, 0.0).method_1021(ceilingFactor);
        class_243 forwards = player.method_18798().method_1029().method_1021(0.325).method_1021(ceilingFactor);
        class_243 impulse = forwards.method_1019(upwards);
        System.out.println("Applying flap impulse: " + String.valueOf(impulse));
        player.method_5762(impulse.field_1352, impulse.field_1351, impulse.field_1350);
        FlightNetworking.sendFlightActionToServer(FlightActionType.FLAP);
    }

    public static void handleFlare(class_1657 player) {
        class_243 velocity = player.method_18798();
        class_243 dragDirection = velocity.method_1029().method_22882();
        double velocitySquared = velocity.method_1027();
        class_243 horizontalVelocity = new class_243(velocity.field_1352, 0.0, velocity.field_1350);
        class_243 horizontalDrag = horizontalVelocity.method_1029().method_22882().method_1021(velocitySquared * 0.08);
        double verticalDrag = 0.0;
        verticalDrag = velocity.field_1351 < 0.0 ? -velocity.field_1351 * Math.max(0.5, Math.abs(velocity.field_1351) * 0.15) : -velocity.field_1351 * 0.08;
        player.method_5762(horizontalDrag.field_1352, verticalDrag, horizontalDrag.field_1350);
    }

    public static void handleModernFlap(class_1657 player) {
        double d0 = 0.1;
        double d1 = 0.55;
        class_243 looking = player.method_5720();
        class_243 delta = player.method_18798();
        class_243 impulse = delta.method_1031(looking.field_1352 * d1 + (looking.field_1352 * d0 - delta.field_1352) * 1.5, looking.field_1351 * d1 + (looking.field_1351 * d0 - delta.field_1351) * 1.5, looking.field_1350 * d1 + (looking.field_1350 * d0 - delta.field_1350) * 1.5).method_1021(FlightHandler.getCeilingFactor(player)).method_1019(FlightHandler.getUpVector(player).method_1021(0.25));
        player.method_5762(impulse.field_1352, impulse.field_1351, impulse.field_1350);
        FlightNetworking.sendFlightActionToServer(FlightActionType.FLAP);
    }

    public static void handleModernBoost(class_1657 player) {
        double d0 = 0.1;
        double d1 = 1.0;
        class_243 looking = player.method_5720();
        class_243 delta = player.method_18798();
        class_243 impulse = delta.method_1031(looking.field_1352 * d1 + (looking.field_1352 * d0 - delta.field_1352) * 1.5, looking.field_1351 * d1 + (looking.field_1351 * d0 - delta.field_1351) * 1.5, looking.field_1350 * d1 + (looking.field_1350 * d0 - delta.field_1350) * 1.5).method_1021(FlightHandler.getCeilingFactor(player)).method_1019(FlightHandler.getUpVector(player).method_1021(0.25));
        player.method_5762(impulse.field_1352, impulse.field_1351, impulse.field_1350);
        FlightNetworking.sendFlightActionToServer(FlightActionType.BOOST);
    }

    private static double getCeilingFactor(class_1657 player) {
        double altitude = player.method_23318();
        if (altitude < (double)CommonConfig.CONFIG.softCeiling) {
            return 1.0;
        }
        if (altitude > (double)CommonConfig.CONFIG.hardCeiling) {
            return 0.0;
        }
        return 1.0 - (altitude - (double)CommonConfig.CONFIG.softCeiling) / (double)(CommonConfig.CONFIG.hardCeiling - CommonConfig.CONFIG.softCeiling);
    }

    private static class_243 getUpVector(class_1657 player) {
        float yaw = player.method_36454() % 360.0f;
        double rads = (double)yaw * (Math.PI / 180);
        class_243 left = new class_243(Math.cos(rads), 0.0, Math.sin(rads));
        return player.method_5720().method_1036(left);
    }

    public static void handleFlightStop() {
        FlightNetworking.sendFlightActionToServer(FlightActionType.STOP);
    }
}

