/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.betterflight.util;

import com.notcharrow.betterflight.client.ClientData;
import com.notcharrow.betterflight.client.gui.ClassicHudOverlay;
import com.notcharrow.betterflight.client.gui.StaminaHudOverlay;
import com.notcharrow.betterflight.common.FlightActionType;
import com.notcharrow.betterflight.config.CommonConfig;
import com.notcharrow.betterflight.networking.FlightNetworking;
import com.notcharrow.betterflight.util.ElytraData;
import com.notcharrow.betterflight.util.FlightHandler;
import java.util.stream.Stream;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3532;

public class InputHandler {
    private static int rechargeTickCounter = 0;
    private static int flareTickCounter = 0;
    public static int charge = CommonConfig.CONFIG.maxCharge;

    public static void classicFlap(class_1657 player) {
        if (ClientData.getCooldown() > 0) {
            return;
        }
        if (InputHandler.spendCharge(player, CommonConfig.CONFIG.flapCost)) {
            FlightHandler.handleClassicFlap(player);
            ClientData.setCooldown(CommonConfig.CONFIG.cooldownTicks);
        }
    }

    public static void modernFlight(class_1657 player) {
        if (ClientData.getCooldown() > 0) {
            return;
        }
        if (InputHandler.canFlap(player) && InputHandler.spendCharge(player, CommonConfig.CONFIG.flapCost)) {
            if (!InputHandler.checkForAir(player.method_37908(), (class_1309)player)) {
                FlightHandler.handleModernBoost(player);
            } else {
                FlightHandler.handleModernFlap(player);
            }
            ClientData.setCooldown(CommonConfig.CONFIG.cooldownTicks);
        }
    }

    private static boolean canFlap(class_1657 player) {
        return ClientData.isWearingFunctionalWings() && !player.method_24828() && player.method_6128();
    }

    private static boolean spendCharge(class_1657 player, int points) {
        if (player.method_7337()) {
            return true;
        }
        if (charge >= points) {
            charge = Math.max(0, charge - points);
            rechargeTickCounter = 0;
            ClassicHudOverlay.setDepletionBorderTimer(5);
            return true;
        }
        return false;
    }

    public static void handleRecharge(class_1657 player) {
        int chargeThreshold;
        if (player.method_7337()) {
            charge = CommonConfig.CONFIG.maxCharge;
            return;
        }
        int n = chargeThreshold = player.method_24828() ? CommonConfig.CONFIG.rechargeTicksOnGround : CommonConfig.CONFIG.rechargeTicksInAir;
        if (rechargeTickCounter < chargeThreshold) {
            ++rechargeTickCounter;
        }
        if (!ClientData.isFlaring() && rechargeTickCounter >= chargeThreshold && charge < CommonConfig.CONFIG.maxCharge && player.method_7344().method_7586() > CommonConfig.CONFIG.minFood) {
            ++charge;
            rechargeTickCounter = 0;
            ClassicHudOverlay.setRechargeBorderTimer(5);
            StaminaHudOverlay.startRegenAnimation();
            FlightNetworking.sendFlightActionToServer(FlightActionType.RECHARGE);
        }
    }

    public static void tryFlare(class_1657 player) {
        if (ClientData.isWearingFunctionalWings() && ClientData.isFlightEnabled() && player.method_5715() && (player.method_7337() || charge > 0 || player.method_5869() || player.method_5771()) && !player.method_24828() && player.method_6128()) {
            if (player.method_5869() || player.method_5771()) {
                FlightHandler.handleFlightStop();
                return;
            }
            FlightHandler.handleFlare(player);
            if (++flareTickCounter >= CommonConfig.CONFIG.flareTicksPerChargePoint) {
                InputHandler.spendCharge(player, 1);
                flareTickCounter = 0;
            }
        } else if (flareTickCounter > 0) {
            --flareTickCounter;
        }
    }

    public static ElytraData findWings(class_1657 player) {
        class_1799 itemStack = InputHandler.findWingsItemStack(player);
        if (itemStack == null) {
            return null;
        }
        int durabilityRemaining = itemStack.method_7936() - itemStack.method_7919();
        float durabilityPercent = (float)itemStack.method_7919() / (float)itemStack.method_7936();
        return new ElytraData(itemStack, durabilityRemaining, durabilityPercent);
    }

    private static class_1799 findWingsItemStack(class_1657 player) {
        class_1799 elytraStack = player.method_6118(class_1304.field_6174);
        if (elytraStack.method_31574(class_1802.field_8833)) {
            return elytraStack;
        }
        if (player.method_6128() || ClientData.isWearingFunctionalWings()) {
            return new class_1799((class_1935)class_1802.field_8833);
        }
        return null;
    }

    public static boolean checkForAir(class_1937 world, class_1309 player) {
        class_238 boundingBox = player.method_5829().method_1012(0.0, 3.5, 0.0).method_1009(1.0, 0.0, 1.0).method_989(0.0, -1.5, 0.0);
        Stream<class_2338> blocks = InputHandler.getBlockPosStream(world, boundingBox);
        return blocks.noneMatch(pos -> world.method_8320(pos).method_26234((class_1922)world, pos) || world.method_8320(pos).method_26227().method_15771());
    }

    private static Stream<class_2338> getBlockPosStream(class_1937 world, class_238 box) {
        int maxZ;
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15357((double)box.field_1320);
        int minY = class_3532.method_15357((double)box.field_1322);
        int maxY = class_3532.method_15357((double)box.field_1325);
        int minZ = class_3532.method_15357((double)box.field_1321);
        return world.method_22341(minX, minY, minZ, maxX, maxY, maxZ = class_3532.method_15357((double)box.field_1324)) ? class_2338.method_29715((class_238)box) : Stream.empty();
    }
}

