/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.mixin;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.client.TalkBalloonsClient;
import com.cerbon.talk_balloons.util.ChatUtils;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import com.cerbon.talk_balloons.util.mixin.ITalkBalloonsPlayer;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ClientPacketListener.class})
public class ClientPacketListenerMixin {
    @Shadow
    @Final
    private Minecraft f_104888_;

    @WrapWithCondition(method={"m_5784_(Lnet/minecraft/network/protocol/game/ClientboundChatPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;m_93051_(Lnet/minecraft/network/chat/ChatType;Lnet/minecraft/network/chat/Component;Ljava/util/UUID;)V")})
    private boolean getChatMessage(Gui instance, ChatType chatType, Component component, UUID sender) {
        String message;
        if (sender == null || chatType != ChatType.CHAT) {
            return true;
        }
        ChatUtils.MessageContents contents = ChatUtils.tryExtractContents(component);
        if (contents != null && sender == Util.f_137441_) {
            sender = contents.sender();
            message = contents.contents();
        } else {
            message = component.getString();
        }
        SynchronizedConfigData config = TalkBalloonsClient.syncedConfigs.getPlayerConfig(sender);
        if (TalkBalloonsClient.hasServerSupport()) {
            return !config.onlyDisplayBalloons();
        }
        ClientLevel level = this.f_104888_.f_91073_;
        if (level == null) {
            return !config.onlyDisplayBalloons();
        }
        LocalPlayer thisClientPlayer = this.f_104888_.f_91074_;
        if (thisClientPlayer != null && thisClientPlayer.m_142081_() == sender && !TalkBalloons.config.showOwnBalloon) {
            return !config.onlyDisplayBalloons();
        }
        Player player = level.m_46003_(sender);
        if (player == null) {
            return !config.onlyDisplayBalloons();
        }
        ((ITalkBalloonsPlayer)player).talk_balloons$createBalloonMessage(message, TalkBalloons.config.balloonAge * 20);
        return !config.onlyDisplayBalloons();
    }
}

