/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.mixin;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.util.HistoricalData;
import com.cerbon.talk_balloons.util.mixin.ITalkBalloonsPlayer;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements ITalkBalloonsPlayer {
    @Unique
    private HistoricalData<Component> talk_balloons$balloonMessages;
    @Unique
    private final Collection<Supplier<Boolean>> talk_balloons$queuedTickEvents = new ConcurrentLinkedDeque<Supplier<Boolean>>();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private void talk_balloons$tryInitHistoricalData() {
        if (this.talk_balloons$balloonMessages == null) {
            this.talk_balloons$balloonMessages = new HistoricalData(TalkBalloons.config.maxBalloons);
        }
    }

    @Override
    public void talk_balloons$createBalloonMessage(Component text, int timeToRemove) {
        this.talk_balloons$tryInitHistoricalData();
        HistoricalData<Component> balloonMessages = this.talk_balloons$getBalloonMessages();
        AtomicInteger currentTick = new AtomicInteger(0);
        this.talk_balloons$queuedTickEvents.add(() -> {
            if (currentTick.getAndIncrement() >= timeToRemove) {
                balloonMessages.remove(text);
                return true;
            }
            return false;
        });
        balloonMessages.add(text);
    }

    @Override
    public HistoricalData<Component> talk_balloons$getBalloonMessages() {
        this.talk_balloons$tryInitHistoricalData();
        return this.talk_balloons$balloonMessages;
    }

    @Inject(method={"m_8119_()V"}, at={@At(value="HEAD")})
    private void tickQueuedEvents(CallbackInfo ci) {
        HashSet<Supplier<Boolean>> eventsToRemove = new HashSet<Supplier<Boolean>>();
        for (Supplier<Boolean> event : this.talk_balloons$queuedTickEvents) {
            if (!event.get().booleanValue()) continue;
            eventsToRemove.add(event);
        }
        if (!eventsToRemove.isEmpty()) {
            this.talk_balloons$queuedTickEvents.removeAll(eventsToRemove);
        }
    }
}

