/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.mixin;

import com.cerbon.talk_balloons.client.TalkBalloonsClient;
import com.cerbon.talk_balloons.util.mixin.IPlayerRenderState;
import com.cerbon.talk_balloons.util.mixin.ITalkBalloonsPlayer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="TAIL")})
    private void tb_setupBalloonRenderState(AbstractClientPlayer player, PlayerRenderState reusedState, float partialTick, CallbackInfo ci) {
        if (!(player instanceof ITalkBalloonsPlayer)) {
            return;
        }
        ITalkBalloonsPlayer playerMixin = (ITalkBalloonsPlayer)player;
        IPlayerRenderState stateMixin = (IPlayerRenderState)reusedState;
        if (playerMixin.talk_balloons$getBalloonMessages() == null || playerMixin.talk_balloons$getBalloonMessages().isEmpty()) {
            stateMixin.tb_setBalloons(null);
            return;
        }
        ((IPlayerRenderState)reusedState).tb_setBalloons(playerMixin.talk_balloons$getBalloonMessages());
        ((IPlayerRenderState)reusedState).tb_setPlayerConfigData(TalkBalloonsClient.syncedConfigs.getPlayerConfig(player.getUUID()));
    }
}

