/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.neoforge.event;

import com.cerbon.talk_balloons.client.TalkBalloonsClient;
import com.cerbon.talk_balloons.config.TBConfig;
import com.cerbon.talk_balloons.network.TBClientPacketHandler;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@EventBusSubscriber(modid="talk_balloons", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TBClientEventsNeoForge {
    private static Screen configScreenToHandle;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> {
            Screen screen;
            configScreenToHandle = screen = (Screen)AutoConfig.getConfigScreen(TBConfig.class, (Screen)parent).get();
            return screen;
        });
        TBConfig.ConfigGuiHandler.init();
    }

    @EventBusSubscriber(modid="talk_balloons", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class TBNeoForgeClientEvents {
        @SubscribeEvent
        public static void onScreenClose(ScreenEvent.Closing event) {
            if (configScreenToHandle != null && event.getScreen() == configScreenToHandle) {
                TBClientPacketHandler.syncBalloonConfig();
            }
        }

        @SubscribeEvent
        public static void onPlayerDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            TalkBalloonsClient.onClientDisconnect();
        }
    }
}

