/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.util;

import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class ChatUtils {
    @Nullable
    public static MessageContents tryExtractContents(Component component) {
        TranslatableContents contents;
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents && (contents = (TranslatableContents)componentContents).getKey().equals("chat.type.text") && contents.getArgs().length >= 2) {
            HoverEvent.EntityTooltipInfo value;
            MutableComponent mutableComponent;
            String message;
            Object arg = contents.getArgs()[0];
            Object arg2 = contents.getArgs()[1];
            if (arg2 instanceof Component) {
                Component component1 = (Component)arg2;
                v0 = component1.getString();
            } else {
                v0 = message = arg2.toString();
            }
            if (arg instanceof MutableComponent && (mutableComponent = (MutableComponent)arg).getStyle().getHoverEvent() != null && mutableComponent.getStyle().getHoverEvent().getAction() != HoverEvent.Action.SHOW_ENTITY && (value = (HoverEvent.EntityTooltipInfo)mutableComponent.getStyle().getHoverEvent().getValue(HoverEvent.Action.SHOW_ENTITY)) != null && value.type == EntityType.PLAYER) {
                UUID uuid = value.id;
                return new MessageContents(uuid, message);
            }
        }
        String sender = null;
        UUID senderUUID = null;
        String[] words = component.getString().split("(\u00a7.)|[^\\w\u00a7]+");
        String[] parts = component.toString().split("key='");
        if (parts.length > 1) {
            String translationKey = parts[1].split("'")[0];
            if (translationKey.contains("commands")) {
                return null;
            }
            if (translationKey.contains("advancement")) {
                return null;
            }
        }
        for (String word : words) {
            UUID possibleUUID;
            if (word.isEmpty() || (possibleUUID = Minecraft.getInstance().getPlayerSocialManager().getDiscoveredUUID(word)) == Util.NIL_UUID) continue;
            sender = word;
            senderUUID = possibleUUID;
            break;
        }
        if (sender == null) {
            return null;
        }
        String message = component.getString().replaceFirst("[\\s\\S]*" + sender + "([^\\p{L}\u00a7]|(\u00a7.)?)+\\s+", "");
        return new MessageContents(senderUUID, message);
    }

    public record MessageContents(UUID sender, String contents) {
    }
}

