/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.client;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.util.HistoricalData;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10789;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public final class BalloonRenderer {
    private static final class_310 client = class_310.method_1551();
    private static final BlendFunction BALLOON_BLEND = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
    private static final RenderPipeline.Snippet BALLOON_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withUniform("DynamicTransforms", class_10789.field_60031).withUniform("Projection", class_10789.field_60031).withVertexShader("core/position_tex_color").withFragmentShader("core/position_tex_color").withSampler("Sampler0").withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27382).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).buildSnippet();
    private static final RenderPipeline MAIN_BALLOON_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{BALLOON_SNIPPET}).withLocation("pipeline/gui_textured").withDepthBias(3.0f, 3.0f).withBlend(BALLOON_BLEND).build();
    private static final RenderPipeline BALLOON_ARROW_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{BALLOON_SNIPPET}).withLocation("pipeline/gui_textured").withDepthBias(0.0f, 0.0f).withBlend(BALLOON_BLEND).build();

    public static void renderBalloons(class_4587 poseStack, class_4597 bufferSource, Vector3f eulerCameraOrientation, class_327 font, HistoricalData<class_2561> messages, float playerHeight, SynchronizedConfigData configData) {
        if (messages.isEmpty()) {
            return;
        }
        Quaternionf rotation = class_7833.field_40716.rotationDegrees(eulerCameraOrientation.y - 180.0f);
        int balloonDistance = 0;
        int previousBalloonHeight = 0;
        int padding = configData.balloonPadding();
        class_2960 balloonTexture = configData.balloonStyle().getTextureId();
        GpuTextureView balloonGpuTexture = client.method_1531().method_4619(balloonTexture).method_71659();
        class_276 renderTarget = client.method_1522();
        CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
        int r = configData.balloonTint() >> 16 & 0xFF;
        int g = configData.balloonTint() >> 8 & 0xFF;
        int b = configData.balloonTint() & 0xFF;
        for (int i = 0; i < messages.size(); ++i) {
            class_287 builder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
            class_2561 message = messages.get(i);
            poseStack.method_22903();
            poseStack.method_22904(0.0, (double)(playerHeight + TalkBalloons.config.balloonsHeightOffset) - 0.4 + (double)padding / 32.0, 0.0);
            poseStack.method_22907((Quaternionfc)rotation);
            poseStack.method_22905(-0.025f, -0.025f, 0.025f);
            RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
            List dividedMessage = font.method_1728((class_5348)message, TalkBalloons.config.maxBalloonWidth);
            int greatestTextWidth = 0;
            for (class_5481 text : dividedMessage) {
                int textWidth = font.method_30880(text);
                if (textWidth <= greatestTextWidth) continue;
                greatestTextWidth = textWidth;
            }
            int balloonWidth = class_3532.method_15340((int)greatestTextWidth, (int)TalkBalloons.config.minBalloonWidth, (int)TalkBalloons.config.maxBalloonWidth);
            int balloonHeight = dividedMessage.size();
            if (balloonWidth % 2 == 0) {
                --balloonWidth;
            }
            if (previousBalloonHeight != 0) {
                balloonDistance += 9 * previousBalloonHeight + TalkBalloons.config.distanceBetweenBalloons + padding * 2;
            }
            previousBalloonHeight = balloonHeight;
            int j = balloonHeight - 1;
            int baseX = balloonWidth / 2;
            int baseY = -balloonHeight - j * 7 - j;
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX - 3 - padding, baseY - balloonDistance - padding, 5, 5, 0.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX - 3 - padding, baseY + 5 - balloonDistance - padding, 5, balloonHeight + j * 8 + padding * 2, 0.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX - 3 - padding, 5 - balloonDistance + padding, 5, 5, 0.0f, 8.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX + 2 - padding, baseY - balloonDistance - padding, balloonWidth - 4 + padding * 2, 5, 6.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX + 2 - padding, baseY + 5 - balloonDistance - padding, balloonWidth - 4 + padding * 2, balloonHeight + j * 8 + padding * 2, 6.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX + 2 - padding, 5 - balloonDistance + padding, balloonWidth - 4 + padding * 2, 5, 6.0f, 8.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, baseX - 1 + padding, baseY - balloonDistance - padding, 5, 5, 12.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, baseX - 1 + padding, baseY + 5 - balloonDistance - padding, 5, balloonHeight + j * 8 + padding * 2, 12.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, baseX - 1 + padding, 5 - balloonDistance + padding, 5, 5, 12.0f, 8.0f, 5, 5, 32, 32);
            if (i == 0) {
                builder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
                BalloonRenderer.blit(poseStack, (class_4588)builder, -3, 9 + padding, 7, 4, 18.0f, 6.0f, 7, 4, 32, 32);
            }
            try (class_9801 meshData = builder.method_60800();){
                GpuBuffer vertexBuffer = class_290.field_1575.uploadImmediateVertexBuffer(meshData.method_60818());
                RenderSystem.class_5590 indexBufferStorage = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                GpuBuffer indexBuffer = indexBufferStorage.method_68274(meshData.method_60822().comp_751());
                VertexFormat.class_5595 indexType = indexBufferStorage.method_31924();
                try (RenderPass pass = encoder.createRenderPass(() -> "Render Balloons", renderTarget.method_71639(), OptionalInt.empty(), renderTarget.method_71640(), OptionalDouble.empty());){
                    pass.bindSampler("Sampler0", balloonGpuTexture);
                    pass.setVertexBuffer(0, vertexBuffer);
                    pass.setIndexBuffer(indexBuffer, indexType);
                    pass.setPipeline(MAIN_BALLOON_PIPELINE);
                    pass.drawIndexed(0, 0, 54, 0);
                    pass.setPipeline(BALLOON_ARROW_PIPELINE);
                    pass.drawIndexed(0, 54, 6, 0);
                }
            }
            RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
            int textColor = class_9848.method_61334((int)configData.textColor());
            if (dividedMessage.size() > 1) {
                int textDistance = 0;
                for (class_5481 text : dividedMessage) {
                    BalloonRenderer.drawString(poseStack, font, text, -font.method_30880(text) / 2 + 1, -(9 * balloonHeight - 10) - balloonDistance + textDistance, textColor, false);
                    textDistance += 9;
                }
            } else {
                BalloonRenderer.drawString(poseStack, font, message.method_30937(), -greatestTextWidth / 2 + 1, balloonHeight - balloonDistance, textColor, false);
            }
            poseStack.method_22909();
        }
    }

    private static void drawString(class_4587 poseStack, class_327 font, class_5481 text, int x, int y, int color, boolean dropShadow) {
        font.method_22942(text, (float)x, (float)y, color, dropShadow, poseStack.method_23760().method_23761(), (class_4597)client.method_22940().method_23000(), class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    private static void blit(class_4587 poseStack, class_4588 consumer, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        int x2 = x + width;
        int y2 = y + height;
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        consumer.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(minU, minV).method_39415(-1);
        consumer.method_22918(matrix, (float)x, (float)y2, 0.0f).method_22913(minU, maxV).method_39415(-1);
        consumer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22913(maxU, maxV).method_39415(-1);
        consumer.method_22918(matrix, (float)x2, (float)y, 0.0f).method_22913(maxU, minV).method_39415(-1);
    }

    private static Vector3f toEulerXyz(Quaternionf quaternionf) {
        float w = quaternionf.w();
        float x = quaternionf.x();
        float y = quaternionf.y();
        float z = quaternionf.z();
        float f = w * x;
        float g = x * x;
        float h = y * y;
        float i = z * z;
        float j = f + g + h + i;
        float k = 2.0f * w * x - 2.0f * y * z;
        float l = (float)Math.asin(k / j);
        if (Math.abs(k) > 0.999f * j) {
            return new Vector3f(l, 2.0f * (float)Math.atan2(y, w), 0.0f);
        }
        return new Vector3f(l, (float)Math.atan2(2.0f * x * z + 2.0f * y * w, f - g - h + i), (float)Math.atan2(2.0f * x * y + 2.0f * w * z, f - g + h - i));
    }

    public static Vector3f toEulerXyzDegrees(Quaternionf quaternionf) {
        Vector3f vec3f = BalloonRenderer.toEulerXyz(quaternionf);
        return new Vector3f((float)Math.toDegrees(vec3f.x()), (float)Math.toDegrees(vec3f.y()), (float)Math.toDegrees(vec3f.z()));
    }
}

