/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.mixin;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.api.TalkBalloonsApi;
import com.cerbon.talk_balloons.client.TalkBalloonsClient;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.UUID;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ChatListener.class})
public class ChatListenerMixin {
    @WrapWithCondition(method={"m_240494_(Lnet/minecraft/network/chat/Component;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;m_93785_(Lnet/minecraft/network/chat/Component;)V")})
    private boolean tryGetChatMessageNCR(ChatComponent instance, Component component) {
        String message;
        if (TalkBalloonsClient.hasServerSupport()) {
            return true;
        }
        ComponentContents componentContents = component.m_214077_();
        if (!(componentContents instanceof TranslatableContents)) {
            return true;
        }
        TranslatableContents contents = (TranslatableContents)componentContents;
        if (!contents.m_237508_().equals("chat.type.text")) {
            return true;
        }
        if (contents.m_237523_().length < 2) {
            return true;
        }
        Object arg = contents.m_237523_()[0];
        Object arg2 = contents.m_237523_()[1];
        if (arg2 instanceof Component) {
            Component component1 = (Component)arg2;
            v0 = component1.getString();
        } else {
            v0 = message = arg2.toString();
        }
        if (!(arg instanceof MutableComponent)) {
            return true;
        }
        MutableComponent mutableComponent = (MutableComponent)arg;
        if (mutableComponent.m_7383_().m_131186_() == null) {
            return true;
        }
        if (mutableComponent.m_7383_().m_131186_().m_130820_() != HoverEvent.Action.f_130833_) {
            return true;
        }
        HoverEvent.EntityTooltipInfo value = (HoverEvent.EntityTooltipInfo)mutableComponent.m_7383_().m_131186_().m_130823_(HoverEvent.Action.f_130833_);
        if (value == null || value.f_130871_ != EntityType.f_20532_) {
            return true;
        }
        UUID uuid = value.f_130872_;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        SynchronizedConfigData config = TalkBalloonsClient.syncedConfigs.getPlayerConfig(uuid);
        if (level == null) {
            return !config.onlyDisplayBalloons();
        }
        LocalPlayer thisClientPlayer = minecraft.f_91074_;
        if (thisClientPlayer != null && thisClientPlayer.m_20148_() == uuid && !TalkBalloons.config.showOwnBalloon) {
            return !config.onlyDisplayBalloons();
        }
        Player player = level.m_46003_(uuid);
        if (player == null) {
            return !config.onlyDisplayBalloons();
        }
        TalkBalloonsApi.INSTANCE.createBalloonMessage(player, (Component)Component.m_237113_((String)message), TalkBalloons.config.balloonAge * 20);
        return !config.onlyDisplayBalloons();
    }

    @WrapWithCondition(method={"m_246494_(Lnet/minecraft/network/chat/ChatType$Bound;Lnet/minecraft/network/chat/PlayerChatMessage;Lnet/minecraft/network/chat/Component;Lcom/mojang/authlib/GameProfile;ZLjava/time/Instant;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;m_240964_(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V", ordinal=0)})
    private boolean getChatMessage(ChatComponent instance, Component component, MessageSignature messageSignature, GuiMessageTag guiMessageTag, @Local(argsOnly=true) PlayerChatMessage chatMessage) {
        SynchronizedConfigData config = TalkBalloonsClient.syncedConfigs.getPlayerConfig(chatMessage.m_245167_());
        if (TalkBalloonsClient.hasServerSupport()) {
            return !config.onlyDisplayBalloons();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return !config.onlyDisplayBalloons();
        }
        LocalPlayer thisClientPlayer = minecraft.f_91074_;
        if (thisClientPlayer != null && thisClientPlayer.m_20148_() == chatMessage.m_245167_() && !TalkBalloons.config.showOwnBalloon) {
            return !config.onlyDisplayBalloons();
        }
        Player player = level.m_46003_(chatMessage.m_245167_());
        if (player == null) {
            return !config.onlyDisplayBalloons();
        }
        TalkBalloonsApi.INSTANCE.createBalloonMessage(player, chatMessage.m_245692_(), TalkBalloons.config.balloonAge * 20);
        return !config.onlyDisplayBalloons();
    }
}

