/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.util;

import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SyncedConfigManager {
    private final Map<UUID, SynchronizedConfigData> configDatas = Collections.synchronizedMap(new HashMap());
    private final Set<UUID> defaultConfigDatas = Collections.synchronizedSet(new HashSet());

    public SynchronizedConfigData getPlayerConfig(UUID uuid) {
        return this.configDatas.computeIfAbsent(uuid, u -> {
            this.defaultConfigDatas.add((UUID)u);
            return SynchronizedConfigData.getDefault();
        });
    }

    public SynchronizedConfigData getSetPlayerConfig(UUID uuid) {
        if (this.defaultConfigDatas.contains(uuid)) {
            return null;
        }
        return this.configDatas.get(uuid);
    }

    public void setPlayerConfig(UUID uuid, SynchronizedConfigData configData) {
        this.configDatas.put(uuid, configData);
        this.defaultConfigDatas.remove(uuid);
    }

    public void removePlayerConfig(UUID uuid) {
        this.configDatas.remove(uuid);
        this.defaultConfigDatas.remove(uuid);
    }

    public void resetConfigs() {
        this.configDatas.clear();
        this.defaultConfigDatas.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDefault() {
        Set<UUID> set = this.defaultConfigDatas;
        synchronized (set) {
            for (UUID uuid : this.defaultConfigDatas) {
                this.configDatas.remove(uuid);
            }
        }
        this.defaultConfigDatas.clear();
    }
}

