/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.mixin;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.util.HistoricalData;
import com.cerbon.talk_balloons.util.mixin.ITalkBalloonsPlayer;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements ITalkBalloonsPlayer {
    @Unique
    private HistoricalData<class_2561> talk_balloons$balloonMessages;
    @Unique
    private final Collection<Supplier<Boolean>> talk_balloons$queuedTickEvents = new ConcurrentLinkedDeque<Supplier<Boolean>>();

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Unique
    private void talk_balloons$tryInitHistoricalData() {
        if (this.talk_balloons$balloonMessages == null) {
            this.talk_balloons$balloonMessages = new HistoricalData(TalkBalloons.config.maxBalloons);
        }
    }

    @Override
    public void talk_balloons$createBalloonMessage(class_2561 text, int timeToRemove) {
        this.talk_balloons$tryInitHistoricalData();
        HistoricalData<class_2561> balloonMessages = this.talk_balloons$getBalloonMessages();
        AtomicInteger currentTick = new AtomicInteger(0);
        this.talk_balloons$queuedTickEvents.add(() -> {
            if (currentTick.getAndIncrement() >= timeToRemove) {
                balloonMessages.remove(text);
                return true;
            }
            return false;
        });
        balloonMessages.add(text);
    }

    @Override
    public HistoricalData<class_2561> talk_balloons$getBalloonMessages() {
        this.talk_balloons$tryInitHistoricalData();
        return this.talk_balloons$balloonMessages;
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void tickQueuedEvents(CallbackInfo ci) {
        HashSet<Supplier<Boolean>> eventsToRemove = new HashSet<Supplier<Boolean>>();
        for (Supplier<Boolean> event : this.talk_balloons$queuedTickEvents) {
            if (!event.get().booleanValue()) continue;
            eventsToRemove.add(event);
        }
        if (!eventsToRemove.isEmpty()) {
            this.talk_balloons$queuedTickEvents.removeAll(eventsToRemove);
        }
    }
}

