/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.network;

import com.cerbon.talk_balloons.api.TalkBalloonsApi;
import com.cerbon.talk_balloons.client.TalkBalloonsClient;
import com.cerbon.talk_balloons.network.TBPackets;
import com.cerbon.talk_balloons.network.packets.SyncBalloonConfigPacket;
import com.cerbon.talk_balloons.network.packets.TalkBalloonsStatusPacket;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.player.Player;
import xyz.bluspring.modernnetworking.api.NetworkPacket;
import xyz.bluspring.modernnetworking.api.minecraft.VanillaNetworkRegistry;
import xyz.bluspring.modernnetworking.api.minecraft.VanillaPacketSender;

public class TBClientPacketHandler {
    public static void init() {
        VanillaNetworkRegistry registry = TBPackets.REGISTRY;
        registry.addClientboundHandler(TBPackets.CREATE_BALLOON, (packet, ctx) -> {
            ClientLevel level = ctx.getClient().level;
            if (level == null) {
                return;
            }
            Player player = level.getPlayerByUUID(packet.uuid());
            if (player == null) {
                return;
            }
            TalkBalloonsApi.INSTANCE.createBalloonMessage(player, packet.message(), packet.getBalloonAge());
        });
        registry.addClientboundHandler(TBPackets.STATUS, (packet, ctx) -> {
            if (packet.protocolVersion() <= 1) {
                TalkBalloonsClient.enableServerSupport();
                VanillaPacketSender.sendToServer((NetworkPacket)new TalkBalloonsStatusPacket(1));
                TBClientPacketHandler.syncBalloonConfig();
            }
        });
        registry.addClientboundHandler(TBPackets.SYNC_CONFIG_TO_PLAYER, (packet, ctx) -> TalkBalloonsClient.syncedConfigs.setPlayerConfig(packet.uuid(), packet.data()));
    }

    public static void syncBalloonConfig() {
        TalkBalloonsClient.syncedConfigs.resetDefault();
        if (TalkBalloonsClient.hasServerSupport()) {
            VanillaPacketSender.sendToServer((NetworkPacket)new SyncBalloonConfigPacket(SynchronizedConfigData.getDefault()));
        }
    }
}

