/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.network;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.network.TBPackets;
import com.cerbon.talk_balloons.network.packets.SyncBalloonConfigToPlayerPacket;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import net.minecraft.server.level.ServerPlayer;
import xyz.bluspring.modernnetworking.api.NetworkPacket;
import xyz.bluspring.modernnetworking.api.minecraft.VanillaNetworkRegistry;
import xyz.bluspring.modernnetworking.api.minecraft.VanillaPacketSender;

public class TBServerPacketHandler {
    public static void init() {
        VanillaNetworkRegistry registry = TBPackets.REGISTRY;
        registry.addServerboundHandler(TBPackets.STATUS, (packet, ctx) -> {
            if (packet.protocolVersion() <= 1) {
                TalkBalloons.addSupportedPlayer(ctx.getPlayer().getUUID());
                for (ServerPlayer player : ctx.getServer().getPlayerList().getPlayers()) {
                    SynchronizedConfigData config = TalkBalloons.serverSyncedConfigs.getSetPlayerConfig(player.getUUID());
                    if (config == null) continue;
                    VanillaPacketSender.sendToPlayer((ServerPlayer)ctx.getPlayer(), (NetworkPacket)new SyncBalloonConfigToPlayerPacket(player.getUUID(), config));
                }
            }
        });
        registry.addServerboundHandler(TBPackets.SYNC_BALLOON_CONFIG, (packet, ctx) -> {
            TalkBalloons.serverSyncedConfigs.setPlayerConfig(ctx.getPlayer().getUUID(), packet.data());
            SyncBalloonConfigToPlayerPacket newPacket = new SyncBalloonConfigToPlayerPacket(ctx.getPlayer().getUUID(), packet.data());
            for (ServerPlayer player : ctx.getServer().getPlayerList().getPlayers()) {
                if (!TalkBalloons.playerHasSupport(player.getUUID())) continue;
                VanillaPacketSender.sendToPlayer((ServerPlayer)player, (NetworkPacket)newPacket);
            }
        });
    }
}

