/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.mixin;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.api.TalkBalloonsApi;
import com.cerbon.talk_balloons.client.TalkBalloonsClient;
import com.cerbon.talk_balloons.util.ChatUtils;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ChatListener.class})
public class ChatListenerMixin {
    @WrapWithCondition(method={"m_240494_(Lnet/minecraft/network/chat/Component;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;m_93785_(Lnet/minecraft/network/chat/Component;)V")})
    private boolean tryGetChatMessageNCR(ChatComponent instance, Component component) {
        if (TalkBalloonsClient.hasServerSupport()) {
            return true;
        }
        ChatUtils.MessageContents contents = ChatUtils.tryExtractContents(component);
        if (contents == null) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        SynchronizedConfigData config = TalkBalloonsClient.syncedConfigs.getPlayerConfig(contents.sender());
        if (level == null) {
            return !config.onlyDisplayBalloons();
        }
        LocalPlayer thisClientPlayer = minecraft.f_91074_;
        if (thisClientPlayer != null && thisClientPlayer.m_20148_() == contents.sender() && !TalkBalloons.config.showOwnBalloon) {
            return !config.onlyDisplayBalloons();
        }
        Player player = level.m_46003_(contents.sender());
        if (player == null) {
            return !config.onlyDisplayBalloons();
        }
        TalkBalloonsApi.INSTANCE.createBalloonMessage(player, (Component)Component.m_237113_((String)contents.contents()), TalkBalloons.config.balloonAge * 20);
        return !config.onlyDisplayBalloons();
    }

    @WrapWithCondition(method={"m_246494_(Lnet/minecraft/network/chat/ChatType$Bound;Lnet/minecraft/network/chat/PlayerChatMessage;Lnet/minecraft/network/chat/Component;Lcom/mojang/authlib/GameProfile;ZLjava/time/Instant;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;m_240964_(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V", ordinal=0)})
    private boolean getChatMessage(ChatComponent instance, Component component, MessageSignature messageSignature, GuiMessageTag guiMessageTag, @Local(argsOnly=true) PlayerChatMessage chatMessage) {
        SynchronizedConfigData config = TalkBalloonsClient.syncedConfigs.getPlayerConfig(chatMessage.m_245167_());
        if (TalkBalloonsClient.hasServerSupport()) {
            return !config.onlyDisplayBalloons();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return !config.onlyDisplayBalloons();
        }
        LocalPlayer thisClientPlayer = minecraft.f_91074_;
        if (thisClientPlayer != null && thisClientPlayer.m_20148_() == chatMessage.m_245167_() && !TalkBalloons.config.showOwnBalloon) {
            return !config.onlyDisplayBalloons();
        }
        Player player = level.m_46003_(chatMessage.m_245167_());
        if (player == null) {
            return !config.onlyDisplayBalloons();
        }
        TalkBalloonsApi.INSTANCE.createBalloonMessage(player, chatMessage.m_245692_(), TalkBalloons.config.balloonAge * 20);
        return !config.onlyDisplayBalloons();
    }
}

