/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.client;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.util.HistoricalData;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_898;

@Environment(value=EnvType.CLIENT)
public final class BalloonRenderer {
    private static final class_310 client = class_310.method_1551();

    public static void renderBalloons(class_4587 poseStack, class_4597 bufferSource, class_898 entityRenderDispatcher, class_327 font, HistoricalData<class_2561> messages, float playerHeight, SynchronizedConfigData configData) {
        if (messages.isEmpty()) {
            return;
        }
        class_1158 rotation = class_1160.field_20705.method_23214(BalloonRenderer.toEulerXyzDegrees(entityRenderDispatcher.method_24197()).method_4945());
        int balloonDistance = 0;
        int previousBalloonHeight = 0;
        int padding = configData.balloonPadding();
        class_2960 balloonTexture = configData.balloonStyle().getTextureId();
        int r = configData.balloonTint() >> 16 & 0xFF;
        int g = configData.balloonTint() >> 8 & 0xFF;
        int b = configData.balloonTint() & 0xFF;
        for (int i = 0; i < messages.size(); ++i) {
            class_287 builder = class_289.method_1348().method_1349();
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)balloonTexture);
            class_2561 message = messages.get(i);
            poseStack.method_22903();
            poseStack.method_22904(0.0, (double)(playerHeight + TalkBalloons.config.balloonsHeightOffset) - 0.4 + (double)padding / 32.0, 0.0);
            poseStack.method_22907(rotation);
            poseStack.method_22905(-0.025f, -0.025f, 0.025f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)3.0f, (float)3.0f);
            RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            List dividedMessage = font.method_1728((class_5348)message, TalkBalloons.config.maxBalloonWidth);
            int greatestTextWidth = 0;
            for (class_5481 text : dividedMessage) {
                int textWidth = font.method_30880(text);
                if (textWidth <= greatestTextWidth) continue;
                greatestTextWidth = textWidth;
            }
            int balloonWidth = class_3532.method_15340((int)greatestTextWidth, (int)TalkBalloons.config.minBalloonWidth, (int)TalkBalloons.config.maxBalloonWidth);
            int balloonHeight = dividedMessage.size();
            if (balloonWidth % 2 == 0) {
                --balloonWidth;
            }
            if (previousBalloonHeight != 0) {
                balloonDistance += 9 * previousBalloonHeight + TalkBalloons.config.distanceBetweenBalloons + padding * 2;
            }
            previousBalloonHeight = balloonHeight;
            int j = balloonHeight - 1;
            int baseX = balloonWidth / 2;
            int baseY = -balloonHeight - j * 7 - j;
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX - 3 - padding, baseY - balloonDistance - padding, 5, 5, 0.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX - 3 - padding, baseY + 5 - balloonDistance - padding, 5, balloonHeight + j * 8 + padding * 2, 0.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX - 3 - padding, 5 - balloonDistance + padding, 5, 5, 0.0f, 8.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX + 2 - padding, baseY - balloonDistance - padding, balloonWidth - 4 + padding * 2, 5, 6.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX + 2 - padding, baseY + 5 - balloonDistance - padding, balloonWidth - 4 + padding * 2, balloonHeight + j * 8 + padding * 2, 6.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, -baseX + 2 - padding, 5 - balloonDistance + padding, balloonWidth - 4 + padding * 2, 5, 6.0f, 8.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, baseX - 1 + padding, baseY - balloonDistance - padding, 5, 5, 12.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, baseX - 1 + padding, baseY + 5 - balloonDistance - padding, 5, balloonHeight + j * 8 + padding * 2, 12.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (class_4588)builder, baseX - 1 + padding, 5 - balloonDistance + padding, 5, 5, 12.0f, 8.0f, 5, 5, 32, 32);
            class_289.method_1348().method_1350();
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            if (i == 0) {
                BalloonRenderer.blit(poseStack, (class_4588)builder, -3, 9 + padding, 7, 4, 18.0f, 6.0f, 7, 4, 32, 32);
            }
            class_289.method_1348().method_1350();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (dividedMessage.size() > 1) {
                int textDistance = 0;
                for (class_5481 text : dividedMessage) {
                    BalloonRenderer.drawString(poseStack, font, text, -font.method_30880(text) / 2 + 1, -(9 * balloonHeight - 10) - balloonDistance + textDistance, configData.textColor(), false);
                    textDistance += 9;
                }
            } else {
                BalloonRenderer.drawString(poseStack, font, message.method_30937(), -greatestTextWidth / 2 + 1, balloonHeight - balloonDistance, configData.textColor(), false);
            }
            poseStack.method_22909();
        }
    }

    private static void drawString(class_4587 poseStack, class_327 font, class_5481 text, int x, int y, int color, boolean dropShadow) {
        font.method_22942(text, (float)x, (float)y, color, dropShadow, poseStack.method_23760().method_23761(), (class_4597)client.method_22940().method_23000(), false, 0, 0xF000F0);
    }

    private static void blit(class_4587 poseStack, class_4588 consumer, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        class_1159 matrix = poseStack.method_23760().method_23761();
        int x2 = x + width;
        int y2 = y + height;
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        consumer.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(minU, minV).method_39415(-1).method_1344();
        consumer.method_22918(matrix, (float)x, (float)y2, 0.0f).method_22913(minU, maxV).method_39415(-1).method_1344();
        consumer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22913(maxU, maxV).method_39415(-1).method_1344();
        consumer.method_22918(matrix, (float)x2, (float)y, 0.0f).method_22913(maxU, minV).method_39415(-1).method_1344();
    }

    private static class_1160 toEulerXyz(class_1158 quaternionf) {
        float w = quaternionf.method_4924();
        float x = quaternionf.method_4921();
        float y = quaternionf.method_4922();
        float z = quaternionf.method_4923();
        float f = w * x;
        float g = x * x;
        float h = y * y;
        float i = z * z;
        float j = f + g + h + i;
        float k = 2.0f * w * x - 2.0f * y * z;
        float l = (float)Math.asin(k / j);
        if (Math.abs(k) > 0.999f * j) {
            return new class_1160(l, 2.0f * (float)Math.atan2(y, w), 0.0f);
        }
        return new class_1160(l, (float)Math.atan2(2.0f * x * z + 2.0f * y * w, f - g - h + i), (float)Math.atan2(2.0f * x * y + 2.0f * w * z, f - g + h - i));
    }

    private static class_1160 toEulerXyzDegrees(class_1158 quaternionf) {
        class_1160 vec3f = BalloonRenderer.toEulerXyz(quaternionf);
        return new class_1160((float)Math.toDegrees(vec3f.method_4943()), (float)Math.toDegrees(vec3f.method_4945()), (float)Math.toDegrees(vec3f.method_4947()));
    }
}

