/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.talk_balloons.client;

import com.cerbon.talk_balloons.TalkBalloons;
import com.cerbon.talk_balloons.util.HistoricalData;
import com.cerbon.talk_balloons.util.SynchronizedConfigData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BalloonRenderer {
    private static final Minecraft client = Minecraft.m_91087_();

    public static void renderBalloons(PoseStack poseStack, MultiBufferSource bufferSource, Vector3f eulerCameraOrientation, Font font, HistoricalData<Component> messages, float playerHeight, SynchronizedConfigData configData) {
        if (messages.isEmpty()) {
            return;
        }
        Quaternion rotation = Vector3f.f_122225_.m_122240_(eulerCameraOrientation.m_122260_());
        int balloonDistance = 0;
        int previousBalloonHeight = 0;
        int padding = configData.balloonPadding();
        ResourceLocation balloonTexture = configData.balloonStyle().getTextureId();
        int r = configData.balloonTint() >> 16 & 0xFF;
        int g = configData.balloonTint() >> 8 & 0xFF;
        int b = configData.balloonTint() & 0xFF;
        for (int i = 0; i < messages.size(); ++i) {
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)balloonTexture);
            Component message = messages.get(i);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)(playerHeight + TalkBalloons.config.balloonsHeightOffset) - 0.4 + (double)padding / 32.0, 0.0);
            poseStack.m_85845_(rotation);
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            RenderSystem.m_69486_();
            RenderSystem.m_69863_((float)3.0f, (float)3.0f);
            RenderSystem.m_157429_((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            List dividedMessage = font.m_92923_((FormattedText)message, TalkBalloons.config.maxBalloonWidth);
            int greatestTextWidth = 0;
            for (FormattedCharSequence text : dividedMessage) {
                int textWidth = font.m_92724_(text);
                if (textWidth <= greatestTextWidth) continue;
                greatestTextWidth = textWidth;
            }
            int balloonWidth = Mth.m_14045_((int)greatestTextWidth, (int)TalkBalloons.config.minBalloonWidth, (int)TalkBalloons.config.maxBalloonWidth);
            int balloonHeight = dividedMessage.size();
            if (balloonWidth % 2 == 0) {
                --balloonWidth;
            }
            if (previousBalloonHeight != 0) {
                balloonDistance += 9 * previousBalloonHeight + TalkBalloons.config.distanceBetweenBalloons + padding * 2;
            }
            previousBalloonHeight = balloonHeight;
            int j = balloonHeight - 1;
            int baseX = balloonWidth / 2;
            int baseY = -balloonHeight - j * 7 - j;
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -baseX - 3 - padding, baseY - balloonDistance - padding, 5, 5, 0.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -baseX - 3 - padding, baseY + 5 - balloonDistance - padding, 5, balloonHeight + j * 8 + padding * 2, 0.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -baseX - 3 - padding, 5 - balloonDistance + padding, 5, 5, 0.0f, 8.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -baseX + 2 - padding, baseY - balloonDistance - padding, balloonWidth - 4 + padding * 2, 5, 6.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -baseX + 2 - padding, baseY + 5 - balloonDistance - padding, balloonWidth - 4 + padding * 2, balloonHeight + j * 8 + padding * 2, 6.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -baseX + 2 - padding, 5 - balloonDistance + padding, balloonWidth - 4 + padding * 2, 5, 6.0f, 8.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, baseX - 1 + padding, baseY - balloonDistance - padding, 5, 5, 12.0f, 0.0f, 5, 5, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, baseX - 1 + padding, baseY + 5 - balloonDistance - padding, 5, balloonHeight + j * 8 + padding * 2, 12.0f, 6.0f, 5, 1, 32, 32);
            BalloonRenderer.blit(poseStack, (VertexConsumer)builder, baseX - 1 + padding, 5 - balloonDistance + padding, 5, 5, 12.0f, 8.0f, 5, 5, 32, 32);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
            RenderSystem.m_69863_((float)0.0f, (float)0.0f);
            RenderSystem.m_69469_();
            if (i == 0) {
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                BalloonRenderer.blit(poseStack, (VertexConsumer)builder, -3, 9 + padding, 7, 4, 18.0f, 6.0f, 7, 4, 32, 32);
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
            }
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = configData.textColor();
            if (dividedMessage.size() > 1) {
                int textDistance = 0;
                for (FormattedCharSequence text : dividedMessage) {
                    BalloonRenderer.drawString(poseStack, font, text, -font.m_92724_(text) / 2 + 1, -(9 * balloonHeight - 10) - balloonDistance + textDistance, textColor, false);
                    textDistance += 9;
                }
            } else {
                BalloonRenderer.drawString(poseStack, font, message.m_7532_(), -greatestTextWidth / 2 + 1, balloonHeight - balloonDistance, textColor, false);
            }
            poseStack.m_85849_();
        }
    }

    private static void drawString(PoseStack poseStack, Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow) {
        font.m_92733_(text, (float)x, (float)y, color, dropShadow, poseStack.m_85850_().m_85861_(), (MultiBufferSource)client.m_91269_().m_110104_(), false, 0, 0xF000F0);
    }

    private static void blit(PoseStack poseStack, VertexConsumer consumer, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        int x2 = x + width;
        int y2 = y + height;
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        consumer.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_193479_(-1).m_5752_();
        consumer.m_85982_(matrix, (float)x, (float)y2, 0.0f).m_7421_(minU, maxV).m_193479_(-1).m_5752_();
        consumer.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_7421_(maxU, maxV).m_193479_(-1).m_5752_();
        consumer.m_85982_(matrix, (float)x2, (float)y, 0.0f).m_7421_(maxU, minV).m_193479_(-1).m_5752_();
    }

    private static Vector3f toEulerXyz(Quaternion quaternionf) {
        float w = quaternionf.m_80156_();
        float x = quaternionf.m_80140_();
        float y = quaternionf.m_80150_();
        float z = quaternionf.m_80153_();
        float f = w * x;
        float g = x * x;
        float h = y * y;
        float i = z * z;
        float j = f + g + h + i;
        float k = 2.0f * w * x - 2.0f * y * z;
        float l = (float)Math.asin(k / j);
        if (Math.abs(k) > 0.999f * j) {
            return new Vector3f(l, 2.0f * (float)Math.atan2(y, w), 0.0f);
        }
        return new Vector3f(l, (float)Math.atan2(2.0f * x * z + 2.0f * y * w, f - g - h + i), (float)Math.atan2(2.0f * x * y + 2.0f * w * z, f - g + h - i));
    }

    public static Vector3f toEulerXyzDegrees(Quaternion quaternionf) {
        Vector3f vec3f = BalloonRenderer.toEulerXyz(quaternionf);
        return new Vector3f((float)Math.toDegrees(vec3f.m_122239_()), (float)Math.toDegrees(vec3f.m_122260_()), (float)Math.toDegrees(vec3f.m_122269_()));
    }
}

