/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.entity;

import com.opryshok.BorukvaFood;
import com.opryshok.block.cooking.Pan;
import com.opryshok.entity.ModEntities;
import com.opryshok.polydex.PolydexCompat;
import com.opryshok.recipe.ModRecipeTypes;
import com.opryshok.recipe.pan.PanInput;
import com.opryshok.recipe.pan.PanRecipe;
import com.opryshok.sounds.SoundRegistry;
import com.opryshok.ui.GuiTextures;
import com.opryshok.ui.LedgerSimpleGui;
import com.opryshok.ui.LedgerSlot;
import com.opryshok.utils.MinimalSidedInventory;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class PanBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
BlockEntityExtraListener,
class_1278 {
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public boolean active = false;
    private int soundTicks = 20;
    private static final int SOUND_PLAY_INTERVAL = 15;
    private final class_2371<class_1799> items = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private final HashMap<Integer, Integer> slotTick = new HashMap();
    protected class_8786<PanRecipe>[] currentRecipes;
    private Pan.Model model;

    public PanBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModEntities.PAN, blockPos, blockState);
        this.slotTick.put(0, 0);
        this.slotTick.put(1, 0);
        this.slotTick.put(2, 0);
        this.currentRecipes = new class_8786[3];
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.items);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.items);
        if (this.model != null) {
            this.model.updateItems(this.getStacks());
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.model != null) {
            this.model.updateItems(this.getStacks());
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (t instanceof PanBlockEntity) {
            PanBlockEntity self = (PanBlockEntity)t;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                self.active = (Boolean)state.method_11654((class_2769)class_2741.field_12548);
                boolean hasItems = self.items.stream().anyMatch(stack -> !stack.method_7960() && !stack.method_31574(class_1802.field_8162));
                if (self.active && hasItems) {
                    for (int i = 0; i < self.items.size(); ++i) {
                        class_1799 stack2 = (class_1799)self.items.get(i);
                        class_8786<PanRecipe> currentRecipe = self.currentRecipes[i];
                        if (currentRecipe == null || !((PanRecipe)currentRecipe.comp_1933()).matches(new PanInput(stack2, world), world)) {
                            self.currentRecipes[i] = serverWorld.method_64577().method_8132(ModRecipeTypes.PAN, (class_9695)new PanInput(stack2, world), world).orElse(null);
                            self.slotTick.put(i, 0);
                        }
                        if (currentRecipe != null) {
                            double recipeTime;
                            int tickCount = self.slotTick.getOrDefault(i, 0);
                            if ((double)tickCount >= (recipeTime = ((PanRecipe)currentRecipe.comp_1933()).time()) * (double)stack2.method_7947()) {
                                class_1799 result = ((PanRecipe)currentRecipe.comp_1933()).craft(new PanInput(stack2, world), (class_7225.class_7874)world.method_30349()).method_46651(stack2.method_7947());
                                self.items.set(i, (Object)result);
                                self.slotTick.put(i, 0);
                                self.currentRecipes[i] = null;
                                self.model.updateItems(self.items);
                                continue;
                            }
                            self.slotTick.put(i, tickCount + 1);
                            continue;
                        }
                        self.slotTick.put(i, 0);
                    }
                    if (self.active) {
                        ++self.soundTicks;
                        if (self.soundTicks >= 15) {
                            float pitch = 0.95f + world.method_8409().method_43057() * 0.1f;
                            float volume = 0.9f + world.method_8409().method_43057() * 0.1f;
                            world.method_8396(null, pos, SoundRegistry.FRYING, class_3419.field_15245, volume, pitch);
                            self.soundTicks = 0;
                        }
                    } else if (self.soundTicks > 0) {
                        self.soundTicks = 0;
                    }
                }
            }
        }
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    public void onListenerUpdate(class_2818 chunk) {
        try {
            this.model = (Pan.Model)Objects.requireNonNull(BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.method_11016())).holder();
            this.model.updateItems(this.items);
        }
        catch (Throwable e) {
            BorukvaFood.LOGGER.debug("error: ", e);
        }
    }

    public class Gui
    extends LedgerSimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_18665, player, false);
            this.setTitle(GuiTextures.PAN.apply((class_2561)class_2561.method_43471((String)"block.borukva-food.pan")));
            this.setSlot(0, (GuiElementInterface)PolydexCompat.getButton(ModRecipeTypes.PAN));
            this.setSlotRedirect(3, new LedgerSlot(PanBlockEntity.this.field_11867, player, (class_1263)PanBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(4, new LedgerSlot(PanBlockEntity.this.field_11867, player, (class_1263)PanBlockEntity.this, 1, 1, 0));
            this.setSlotRedirect(5, new LedgerSlot(PanBlockEntity.this.field_11867, player, (class_1263)PanBlockEntity.this, 2, 2, 0));
            this.setSlot(13, (GuiElementInterface)GuiTextures.FLAME.get(PanBlockEntity.this.active ? 1.0f : 0.0f));
            this.open();
        }

        public void onTick() {
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)PanBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.FLAME.get(PanBlockEntity.this.active ? 1.0f : 0.0f));
            super.onTick();
        }
    }
}

