/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.opryshok.BorukvaFood;
import com.opryshok.ui.ResourceUtils;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.class_11719;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class UiResourceCreator {
    public static final String BASE_MODEL = "minecraft:item/generated";
    public static final String X32_MODEL = "borukva-food:sgui/button_32";
    public static final String X32_RIGHT_MODEL = "borukva-food:sgui/button_32_right";
    private static final String ITEM_TEMPLATE = "{\n  \"parent\": \"|BASE|\",\n  \"textures\": {\n    \"layer0\": \"|ID|\"\n  }\n}\n".replace(" ", "").replace("\n", "");
    public static final class_2583 STYLE = class_2583.field_24360.method_36139(0xFFFFFF).method_27704((class_11719)new class_11719.class_11721(BorukvaFood.id("gui")));
    private static char character = (char)97;
    private static final Char2IntMap SPACES = new Char2IntOpenHashMap();
    private static final List<class_3545<class_2960, String>> SIMPLE_MODEL = new ArrayList<class_3545<class_2960, String>>();
    private static final List<SlicedTexture> VERTICAL_PROGRESS = new ArrayList<SlicedTexture>();
    private static final List<SlicedTexture> HORIZONTAL_PROGRESS = new ArrayList<SlicedTexture>();
    private static final List<FontTexture> FONT_TEXTURES = new ArrayList<FontTexture>();
    private static final char CHEST_SPACE0;
    private static final char CHEST_SPACE1;

    public static Function<class_2561, class_2561> background(String path) {
        StringBuilder builder = new StringBuilder().append(CHEST_SPACE0);
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        builder.append(c2);
        builder.append(CHEST_SPACE1);
        FontTexture texture = new FontTexture(BorukvaFood.id("sgui/" + path), 13, 256, new char[][]{{c2}});
        FONT_TEXTURES.add(texture);
        return new TextBuilders((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(STYLE));
    }

    public static Supplier<GuiElementBuilder> icon16(String path) {
        class_1799 stack = UiResourceCreator.genericIconRaw(path, BASE_MODEL);
        return () -> new GuiElementBuilder(stack).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static Supplier<GuiElementBuilder> icon32(String path) {
        class_1799 stack = UiResourceCreator.genericIconRaw(path, X32_MODEL);
        return () -> new GuiElementBuilder(stack).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    public static class_1799 genericIconRaw(String path, String base) {
        class_2960 elementPath = UiResourceCreator.elementPath(path);
        SIMPLE_MODEL.add((class_3545<class_2960, String>)new class_3545((Object)elementPath, (Object)base));
        return ItemDisplayElementUtil.getModel((class_2960)elementPath);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress16(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, BASE_MODEL, VERTICAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress32Right(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_RIGHT_MODEL, HORIZONTAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> genericProgress(String path, int start, int stop, boolean reverse, String base, List<SlicedTexture> progressType) {
        class_1799[] models = new class_1799[stop - start];
        progressType.add(new SlicedTexture(path, start, stop, reverse));
        for (int i2 = start; i2 < stop; ++i2) {
            models[i2 - start] = UiResourceCreator.genericIconRaw("gen/" + path + "_" + i2, base);
        }
        return i -> new GuiElementBuilder(models[i]).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip();
    }

    private static void generateProgress(BiConsumer<String, byte[]> assetWriter, List<SlicedTexture> list, boolean horizontal) {
        for (SlicedTexture pair : list) {
            BufferedImage sourceImage = ResourceUtils.getTexture(UiResourceCreator.elementPath(pair.path()));
            BufferedImage image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
            int xw = horizontal ? image.getHeight() : image.getWidth();
            int mult = pair.reverse ? -1 : 1;
            int offset = pair.reverse ? pair.stop + pair.start - 1 : 0;
            for (int y = pair.start; y < pair.stop; ++y) {
                class_2960 path = UiResourceCreator.elementPath("gen/" + pair.path + "_" + y);
                int pos = offset + y * mult;
                for (int x = 0; x < xw; ++x) {
                    if (horizontal) {
                        image.setRGB(pos, x, sourceImage.getRGB(pos, x));
                        continue;
                    }
                    image.setRGB(x, pos, sourceImage.getRGB(x, pos));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                assetWriter.accept(AssetPaths.texture((String)path.method_12836(), (String)(path.method_12832() + ".png")), out.toByteArray());
            }
        }
    }

    public static void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        for (class_3545<class_2960, String> texture : SIMPLE_MODEL) {
            assetWriter.accept("assets/" + ((class_2960)texture.method_15442()).method_12836() + "/models/" + ((class_2960)texture.method_15442()).method_12832() + ".json", ITEM_TEMPLATE.replace("|ID|", ((class_2960)texture.method_15442()).toString()).replace("|BASE|", (CharSequence)texture.method_15441()).getBytes(StandardCharsets.UTF_8));
        }
        UiResourceCreator.generateProgress(assetWriter, VERTICAL_PROGRESS, false);
        UiResourceCreator.generateProgress(assetWriter, HORIZONTAL_PROGRESS, true);
        JsonObject fontBase = new JsonObject();
        JsonArray providers = new JsonArray();
        JsonObject spaces = new JsonObject();
        spaces.addProperty("type", "space");
        JsonObject advances = new JsonObject();
        SPACES.char2IntEntrySet().stream().sorted(Comparator.comparing(Char2IntMap.Entry::getCharKey)).forEach(c -> advances.addProperty(Character.toString(c.getCharKey()), (Number)c.getIntValue()));
        spaces.add("advances", (JsonElement)advances);
        providers.add((JsonElement)spaces);
        FONT_TEXTURES.forEach(entry -> {
            JsonObject bitmap = new JsonObject();
            bitmap.addProperty("type", "bitmap");
            bitmap.addProperty("file", String.valueOf(entry.path) + ".png");
            bitmap.addProperty("ascent", (Number)entry.ascent);
            bitmap.addProperty("height", (Number)entry.height);
            JsonArray chars = new JsonArray();
            for (char[] a : entry.chars) {
                StringBuilder builder = new StringBuilder();
                for (char b : a) {
                    builder.append(b);
                }
                chars.add(builder.toString());
            }
            bitmap.add("chars", (JsonElement)chars);
            providers.add((JsonElement)bitmap);
        });
        fontBase.add("providers", (JsonElement)providers);
        assetWriter.accept("assets/borukva-food/font/gui.json", fontBase.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static class_3545<class_2561, class_2561> polydexBackground(String path) {
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        char c3 = character;
        character = (char)(c3 + '\u0001');
        char d = c3;
        FontTexture texture = new FontTexture(BorukvaFood.id("sgui/polydex/" + path), -4, 128, new char[][]{{c2}, {d}});
        FONT_TEXTURES.add(texture);
        return new class_3545((Object)class_2561.method_43470((String)Character.toString(c2)).method_10862(STYLE), (Object)class_2561.method_43470((String)Character.toString(d)).method_10862(STYLE));
    }

    public static void setup() {
        SPACES.put(CHEST_SPACE0, -8);
        SPACES.put(CHEST_SPACE1, -168);
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> UiResourceCreator.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
    }

    private static class_2960 elementPath(String path) {
        return class_2960.method_60655((String)"borukva-food", (String)("item/elements/" + path));
    }

    static {
        char c = character;
        character = (char)(c + '\u0001');
        CHEST_SPACE0 = c;
        char c2 = character;
        character = (char)(c2 + '\u0001');
        CHEST_SPACE1 = c2;
    }

    public record FontTexture(class_2960 path, int ascent, int height, char[][] chars) {
    }

    private record TextBuilders(class_2561 base) implements Function<class_2561, class_2561>
    {
        @Override
        public class_2561 apply(class_2561 text) {
            return class_2561.method_43473().method_10852(this.base).method_10852(text);
        }
    }

    public record SlicedTexture(String path, int start, int stop, boolean reverse) {
    }
}

