/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.entity;

import com.opryshok.block.ModBlocks;
import com.opryshok.entity.ModEntities;
import com.opryshok.item.ModItems;
import com.opryshok.sounds.SoundRegistry;
import com.opryshok.ui.GuiTextures;
import com.opryshok.ui.LedgerSimpleGui;
import com.opryshok.ui.LedgerSlot;
import com.opryshok.utils.MinimalSidedInventory;
import com.opryshok.utils.ModProperties;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FertilizerSprayerBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
class_1278 {
    private static final int[] SLOTS = new int[]{0, 1};
    public static final int AREA_SIZE = 9;
    private int ticks = 1200;
    private final class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);

    public FertilizerSprayerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModEntities.FERTILIZER_SPRAYER, blockPos, blockState);
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot == 0 && stack.method_31574(ModItems.FERTILIZER)) {
            return true;
        }
        return slot == 1 && stack.method_31574(ModItems.COMPOST);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (t instanceof FertilizerSprayerBlockEntity) {
            FertilizerSprayerBlockEntity self = (FertilizerSprayerBlockEntity)t;
            if (((Boolean)state.method_11654((class_2769)class_2741.field_12484)).booleanValue()) {
                if (self.ticks == 1200) {
                    self.ticks = 0;
                    class_2338 startPos = pos.method_10069(-4, -4, -4);
                    class_2338 endPos = pos.method_10069(4, 4, 4);
                    AtomicBoolean play = new AtomicBoolean(false);
                    class_2338.method_20437((class_2338)startPos, (class_2338)endPos).forEach(blockPos -> {
                        class_2680 blockState = world.method_8320(blockPos);
                        if (blockState.method_27852(ModBlocks.BETTER_FARMLAND)) {
                            for (class_1799 item : self.items) {
                                int acidity;
                                int fertility;
                                class_2680 farmlandState;
                                if (item.method_31574(ModItems.FERTILIZER)) {
                                    farmlandState = world.method_8320(blockPos);
                                    fertility = (Integer)farmlandState.method_11654((class_2769)ModProperties.FERTILITY);
                                    acidity = (Integer)farmlandState.method_11654((class_2769)ModProperties.ACIDITY);
                                    if ((fertility > 8 || acidity <= 3) && acidity <= 7) continue;
                                    world.method_8501(blockPos, (class_2680)((class_2680)farmlandState.method_11657((class_2769)ModProperties.FERTILITY, (Comparable)Integer.valueOf(Math.min(fertility + 2, 10)))).method_11657((class_2769)ModProperties.ACIDITY, (Comparable)Integer.valueOf(Math.max(acidity - 1, 0))));
                                    item.method_7934(1);
                                    play.set(true);
                                    continue;
                                }
                                if (!item.method_31574(ModItems.COMPOST)) continue;
                                farmlandState = world.method_8320(blockPos);
                                fertility = (Integer)farmlandState.method_11654((class_2769)ModProperties.FERTILITY);
                                acidity = (Integer)farmlandState.method_11654((class_2769)ModProperties.ACIDITY);
                                if ((fertility > 8 || acidity >= 7) && acidity >= 3) continue;
                                world.method_8501(blockPos, (class_2680)((class_2680)farmlandState.method_11657((class_2769)ModProperties.FERTILITY, (Comparable)Integer.valueOf(Math.min(fertility + 2, 10)))).method_11657((class_2769)ModProperties.ACIDITY, (Comparable)Integer.valueOf(Math.min(acidity + 1, 10))));
                                item.method_7934(1);
                                play.set(true);
                            }
                        }
                    });
                    if (play.get()) {
                        world.method_8396(null, pos, SoundRegistry.SPRAYING, class_3419.field_15245, 0.5f, 1.0f);
                    }
                } else {
                    ++self.ticks;
                }
            } else {
                self.ticks = 1200;
            }
        }
    }

    public class Gui
    extends LedgerSimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_18665, player, false);
            this.setTitle(GuiTextures.FERTILIZER_SPRAYER.apply((class_2561)class_2561.method_43471((String)"block.borukva-food.fertilizer_sprayer")));
            this.setSlotRedirect(12, new LedgerSlot(this, FertilizerSprayerBlockEntity.this.field_11867, player, (class_1263)FertilizerSprayerBlockEntity.this, 0, 0, 0){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_31574(ModItems.FERTILIZER);
                }
            });
            this.setSlotRedirect(14, new LedgerSlot(this, FertilizerSprayerBlockEntity.this.field_11867, player, (class_1263)FertilizerSprayerBlockEntity.this, 1, 1, 0){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_31574(ModItems.COMPOST);
                }
            });
            this.open();
        }

        public void onTick() {
            if (this.player.method_19538().method_1025(class_243.method_24953((class_2382)FertilizerSprayerBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            super.onTick();
        }
    }
}

