/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.polydex.pages;

import com.opryshok.block.ModBlocks;
import com.opryshok.polydex.PolydexCompatImpl;
import com.opryshok.polydex.PolydexTextures;
import com.opryshok.polydex.pages.PrioritizedRecipePage;
import com.opryshok.recipe.pot.PotRecipe;
import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PotRecipePage
extends PrioritizedRecipePage<PotRecipe> {
    private static final class_1799 ICON = ModBlocks.POT_ITEM.method_7854();
    private final List<PolydexIngredient<?>> ingredients;
    private final Optional<PolydexIngredient<?>> bowl;
    private final PolydexStack<?> output;

    public PotRecipePage(class_8786<PotRecipe> recipe) {
        super(recipe);
        this.ingredients = PolydexCompatImpl.createIngredients(((PotRecipe)recipe.comp_1933()).input());
        this.bowl = ((PotRecipe)recipe.comp_1933()).bowl().ingredient().map(PolydexIngredient::of);
        this.output = PolydexStack.of((class_1799)((PotRecipe)this.recipe).output());
    }

    public class_1799 getOutput(@Nullable PolydexEntry polydexEntry, MinecraftServer minecraftServer) {
        return ((PotRecipe)this.recipe).output().method_7972();
    }

    @Nullable
    public class_2561 texture(class_3222 player) {
        return PolydexTextures.POT;
    }

    public boolean isOwner(MinecraftServer server, PolydexEntry entry) {
        return entry.isPartOf(this.output);
    }

    public class_1799 entryIcon(@Nullable PolydexEntry entry, class_3222 player) {
        return ((PotRecipe)this.recipe).output();
    }

    public class_1799 typeIcon(class_3222 serverPlayerEntity) {
        return ICON;
    }

    public List<PolydexIngredient<?>> ingredients() {
        return this.ingredients;
    }

    public void createPage(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity, PageBuilder pageBuilder) {
        for (int i = 0; i < this.ingredients.size() && i < 6; ++i) {
            int column = i % 3;
            int row = 1 + i / 3;
            pageBuilder.setIngredient(column, row, this.ingredients.get(i));
        }
        this.bowl.ifPresent(ingredient -> {
            if (!ingredient.isEmpty()) {
                pageBuilder.setIngredient(7, 1, ingredient);
            }
        });
        pageBuilder.setOutput(7, 3, new PolydexStack[]{this.output});
    }
}

