/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.ui;

import com.opryshok.BorukvaFood;
import com.opryshok.ui.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class GuiTextures {
    public static final Supplier<GuiElementBuilder> EMPTY_BUILDER = UiResourceCreator.icon16("empty");
    public static final Supplier<GuiElementBuilder> POLYDEX_BUTTON = UiResourceCreator.icon32("polydex");
    public static final GuiElement EMPTY = EMPTY_BUILDER.get().hideTooltip().build();
    public static final Function<class_2561, class_2561> STOVE = UiResourceCreator.background("stove");
    public static final Function<class_2561, class_2561> PAN = UiResourceCreator.background("pan");
    public static final Function<class_2561, class_2561> POT = UiResourceCreator.background("pot");
    public static final Function<class_2561, class_2561> FERTILIZER_SPRAYER = UiResourceCreator.background("fertilizer_sprayer");
    public static final Progress FLAME = Progress.createVertical("flame", 1, 14, true);
    public static final Progress PROGRESS_HORIZONTAL_OFFSET_RIGHT = Progress.createHorizontal32Right("progress_horizontal_offset_right", 6, 26, false);

    public static void register() {
        BorukvaFood.LOGGER.info("Gui Textures register");
    }

    public record Progress(GuiElement[] elements, class_1799[] withTooltip) {
        public GuiElement get(float progress) {
            return this.elements[Math.min((int)(progress * (float)this.elements.length), this.elements.length - 1)];
        }

        public static Progress createHorizontal32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32Right(path, start, stop, reverse);
            return Progress.create(size, function);
        }

        private static Progress create(int size, IntFunction<GuiElementBuilder> function) {
            GuiElement[] elements = new GuiElement[size + 1];
            class_1799[] withTooltip = new class_1799[size + 1];
            elements[0] = EMPTY;
            withTooltip[0] = EMPTY.getItemStack().method_7972();
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).hideTooltip().build();
                withTooltip[i] = function.apply(i - 1).asStack();
            }
            return new Progress(elements, withTooltip);
        }

        public static Progress createVertical(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress16(path, start, stop, reverse);
            return Progress.create(size, function);
        }
    }
}

