/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.block;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2440;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class PolyPressurePlate
extends class_2440
implements FactoryBlock {
    private final class_2960 id;
    private final class_2248 template;

    public PolyPressurePlate(class_8177 blockSet, class_4970.class_2251 settings, class_2248 template) {
        super(blockSet, settings);
        this.template = template;
        this.id = class_2960.method_12829((String)this.method_63499().replace("block.", "").replace(".", ":"));
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return (class_2680)this.template.method_9564().method_11657((class_2769)field_11358, (Comparable)((Boolean)state.method_11654((class_2769)field_11358)));
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState, this.id);
    }

    public static final class Model
    extends BlockModel {
        public final class_1799 MODEL_UNPOWERED;
        public final class_1799 MODEL_POWERED;
        public ItemDisplayElement main;
        private static final Queue<Model> toBeTicked = new ArrayDeque<Model>();
        private static final Timer timer = new Timer("Polywood: Pressure Plate Update Timer");

        public Model(class_2680 state, class_2960 id) {
            this.MODEL_UNPOWERED = ItemDisplayElementUtil.getModel((class_2960)class_2960.method_60655((String)id.method_12836(), (String)("block/" + id.method_12832())));
            this.MODEL_POWERED = ItemDisplayElementUtil.getModel((class_2960)class_2960.method_60655((String)id.method_12836(), (String)("block/" + id.method_12832() + "_down")));
            this.main = ItemDisplayElementUtil.createSimple();
            this.updateItem((Boolean)state.method_11654((class_2769)class_2440.field_11358));
            this.addElement((VirtualElement)this.main);
        }

        private void updateItem(boolean powered) {
            this.main.setItem(powered ? this.MODEL_POWERED : this.MODEL_UNPOWERED);
            float scale = 1.01f;
            this.main.setScale((Vector3fc)new Vector3f(powered ? scale : 2.0f * scale));
            float scaleOffset = (scale - 1.0f) / 2.0f;
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, scaleOffset, 0.0f));
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                if (!((Boolean)this.blockState().method_11654((class_2769)class_2440.field_11358)).booleanValue()) {
                    this.updateItem(false);
                    this.tick();
                } else {
                    toBeTicked.add(this);
                    timer.schedule(new TimerTask(this){

                        @Override
                        public void run() {
                            if (!toBeTicked.isEmpty()) {
                                Model model = toBeTicked.peek();
                                model.updateItem(true);
                                model.tick();
                                toBeTicked.remove();
                            }
                        }
                    }, 100L);
                }
            }
            super.notifyUpdate(updateType);
        }
    }
}

