/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.entity;

import com.opryshok.BorukvaFood;
import com.opryshok.block.ModBlocks;
import com.opryshok.block.cooking.Pot;
import com.opryshok.entity.ModEntities;
import com.opryshok.polydex.PolydexCompat;
import com.opryshok.recipe.ModRecipeTypes;
import com.opryshok.recipe.pot.PotInput;
import com.opryshok.recipe.pot.PotRecipe;
import com.opryshok.sounds.SoundRegistry;
import com.opryshok.ui.GuiTextures;
import com.opryshok.ui.LedgerSimpleGui;
import com.opryshok.ui.LedgerSlot;
import com.opryshok.utils.InventoryList;
import com.opryshok.utils.MinimalSidedInventory;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class PotBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
class_1278,
BlockEntityExtraListener {
    private final int INPUT_FIRST = 0;
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int OUTPUT_SLOT = 7;
    protected double process = 0.0;
    private boolean active;
    private Pot.Model model;
    private class_1799 delayedOutput;
    private boolean inventoryChanged = true;
    private int soundTicks = 20;
    @Nullable
    protected class_8786<PotRecipe> currentRecipe = null;
    private final List<class_1799> stacks = new InventoryList((class_1263)this, 0, 6);
    private final class_2371<class_1799> items = class_2371.method_10213((int)8, (Object)class_1799.field_8037);

    public PotBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModEntities.POT, blockPos, blockState);
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.items);
        view.method_71463("Progress", this.process);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.items);
        this.process = view.method_71422("Progress", 0.0);
        if (this.model != null) {
            this.model.tick();
        }
    }

    private boolean isInputEmpty() {
        for (int i = 0; i < 6; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        class_3218 serverWorld;
        PotBlockEntity self = (PotBlockEntity)t;
        self.active = (Boolean)state.method_11654((class_2769)class_2741.field_12548);
        if (self.isInputEmpty()) {
            self.process = 0.0;
            self.model.tick();
            return;
        }
        if (self.currentRecipe == null && !self.inventoryChanged) {
            self.process = 0.0;
            self.model.tick();
            self.inventoryChanged = false;
            return;
        }
        PotInput input = new PotInput(self.stacks, self.method_5438(6), world);
        if (world instanceof class_3218) {
            serverWorld = (class_3218)world;
            if (self.inventoryChanged && (self.currentRecipe == null || !((PotRecipe)self.currentRecipe.comp_1933()).matches(input, world))) {
                self.process = 0.0;
                self.currentRecipe = serverWorld.method_64577().method_8132(ModRecipeTypes.POT, (class_9695)input, world).orElse(null);
                if (self.currentRecipe == null) {
                    self.model.tick();
                    self.inventoryChanged = false;
                    return;
                }
            }
        }
        self.inventoryChanged = false;
        if (!((Boolean)self.method_11010().method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            self.model.tick();
            return;
        }
        assert (self.currentRecipe != null);
        if (self.process >= ((PotRecipe)self.currentRecipe.comp_1933()).time()) {
            class_1799 nextOut;
            if (self.delayedOutput != null) {
                nextOut = self.delayedOutput;
                self.delayedOutput = null;
            } else {
                assert (self.field_11863 != null);
                nextOut = ((PotRecipe)self.currentRecipe.comp_1933()).craft(input, (class_7225.class_7874)self.field_11863.method_30349());
            }
            class_1799 currentOut = self.method_5438(7);
            boolean success = false;
            if (currentOut.method_7960()) {
                success = true;
                self.method_5447(7, nextOut);
            } else {
                assert (nextOut != null);
                if (class_1799.method_31577((class_1799)currentOut, (class_1799)nextOut) && currentOut.method_7947() + nextOut.method_7947() <= 64) {
                    success = true;
                    currentOut.method_7933(nextOut.method_7947());
                }
            }
            if (success) {
                self.process = 0.0;
                ((PotRecipe)self.currentRecipe.comp_1933()).applyRecipeUse(self, world);
            } else {
                self.delayedOutput = nextOut;
            }
        } else {
            self.process += 1.0;
            if (world instanceof class_3218 && (serverWorld = (class_3218)world).method_8510() % 40L == 0L && serverWorld.method_8320(pos).method_27852(ModBlocks.POT) && ((Boolean)serverWorld.method_8320(pos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                for (int i = 0; i < 5; ++i) {
                    serverWorld.method_65096((class_2394)class_2398.field_17430, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.25, (double)pos.method_10260() + 0.5, 1, 0.15, 0.4, 0.15, 0.0);
                }
            }
            if (self.soundTicks >= 20) {
                world.method_8396(null, pos, SoundRegistry.BOILING, class_3419.field_15245, 1.0f, 1.0f);
                self.soundTicks = 0;
            } else {
                ++self.soundTicks;
            }
        }
    }

    public int[] method_5494(class_2350 side) {
        return INPUT_SLOTS;
    }

    public void method_5431() {
        super.method_5431();
        this.inventoryChanged = true;
    }

    private float progress() {
        return this.currentRecipe != null ? (float)class_3532.method_15350((double)(this.process / ((PotRecipe)this.currentRecipe.comp_1933()).time()), (double)0.0, (double)1.0) : 0.0f;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    public void onListenerUpdate(class_2818 chunk) {
        try {
            this.model = (Pot.Model)Objects.requireNonNull(BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.method_11016())).holder();
        }
        catch (Throwable e) {
            BorukvaFood.LOGGER.debug("error: ", e);
        }
    }

    public class Gui
    extends LedgerSimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.setTitle(GuiTextures.POT.apply((class_2561)class_2561.method_43471((String)"block.borukva-food.pot")));
            this.setSlot(17, (GuiElementInterface)PolydexCompat.getButton(ModRecipeTypes.POT));
            this.setSlotRedirect(0, new LedgerSlot(PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(1, new LedgerSlot(PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 1, 1, 0));
            this.setSlotRedirect(2, new LedgerSlot(PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 2, 2, 0));
            this.setSlotRedirect(9, new LedgerSlot(PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 3, 3, 0));
            this.setSlotRedirect(10, new LedgerSlot(PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 4, 4, 0));
            this.setSlotRedirect(11, new LedgerSlot(PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 5, 5, 0));
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(PotBlockEntity.this.progress()));
            this.setSlot(19, (GuiElementInterface)GuiTextures.FLAME.get(PotBlockEntity.this.active ? 1.0f : 0.0f));
            this.setSlotRedirect(7, new LedgerSlot(this, PotBlockEntity.this.field_11867, player, (class_1263)PotBlockEntity.this, 6, 6, 0){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_31574(class_1802.field_8428);
                }
            });
            this.setSlotRedirect(25, (class_1735)new class_1719((class_1657)player, (class_1263)PotBlockEntity.this, 7, 3, 0));
            this.open();
        }

        public void onTick() {
            if (this.player.method_19538().method_1025(class_243.method_24953((class_2382)PotBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(PotBlockEntity.this.progress()));
            this.setSlot(19, (GuiElementInterface)GuiTextures.FLAME.get(PotBlockEntity.this.active ? 1.0f : 0.0f));
            super.onTick();
            super.onTick();
        }
    }
}

