/*
 * Decompiled with CFR 0.152.
 */
package com.opryshok.ui;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public class ResourceUtils {
    public static BufferedImage getTexture(class_2960 identifier) {
        try {
            return ImageIO.read(ResourceUtils.getJarStream("assets/" + identifier.method_12836() + "/textures/" + identifier.method_12832() + ".png"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new BufferedImage(16, 16, 2);
        }
    }

    public static JsonObject getModel(class_2960 identifier) {
        try {
            return (JsonObject)JsonParser.parseString((String)new String(ResourceUtils.getJarData("assets/" + identifier.method_12836() + "/models/" + identifier.method_12832() + " .json"), StandardCharsets.UTF_8));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new JsonObject();
        }
    }

    public static byte[] getJarData(String jarPath) throws IOException {
        Path path = ResourceUtils.findAsset(jarPath);
        return path != null ? Files.readAllBytes(path) : null;
    }

    public static InputStream getJarStream(String jarPath) throws IOException {
        Path path = ResourceUtils.findAsset(jarPath);
        return path != null ? Files.newInputStream(path, new OpenOption[0]) : null;
    }

    public static Path findAsset(String jarPath) {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            for (Path basePath : mod.getRootPaths()) {
                Path path = basePath.resolve(jarPath);
                if (!Files.exists(path, new LinkOption[0])) continue;
                try {
                    return path;
                }
                catch (Throwable throwable) {
                }
            }
        }
        Path path = Objects.requireNonNull(PolymerCommonUtils.getClientJar()).resolve(jarPath);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return path;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

