/*
 * Decompiled with CFR 0.152.
 */
package io.github.glxyarcane.signShopPaper;

import io.github.glxyarcane.signShopPaper.SignShopSaveManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class SignShopPlugin
extends JavaPlugin
implements Listener {
    private final Map<UUID, ShopConfig> pendingShops = new HashMap<UUID, ShopConfig>();
    private final Map<UUID, Block> linkingMode = new HashMap<UUID, Block>();
    private final Map<Block, ShopData> shopRegistry = new HashMap<Block, ShopData>();
    private SignShopSaveManager saveManager;

    public void onEnable() {
        this.getLogger().info("SignShop initializing...");
        this.saveManager = new SignShopSaveManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveManager.loadShops(this.shopRegistry);
        new BukkitRunnable(){

            public void run() {
                SignShopPlugin.this.checkAllShops();
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        this.getLogger().info("SignShop enabled!");
    }

    public void onDisable() {
        this.saveManager.saveShops(this.shopRegistry);
        this.getLogger().info("SignShop disabled!");
    }

    private void checkAllShops() {
        for (Map.Entry<Block, ShopData> entry : this.shopRegistry.entrySet()) {
            Block signBlock = entry.getKey();
            BlockState blockState = signBlock.getState();
            if (!(blockState instanceof Sign)) continue;
            Sign sign = (Sign)blockState;
            this.updateSignEffects(sign, entry.getValue());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Players only!", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage((Component)Component.text((String)"Usage: /signshop <sell|price|clear>", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            player.sendMessage((Component)Component.text((String)"=== Sign Shop Plugin by GLXY_ARCANE ===", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            player.sendMessage((Component)Component.text((String)"To use: Place a sign and write [Shop] on the top line. Exit the sign and place a chest. Once done, do the following commands"));
            player.sendMessage((Component)Component.text((String)"Set the item you would like to sell: /signshop sell <Amount you want to sell> <The item you want to sell>"));
            player.sendMessage((Component)Component.text((String)"Set the price of the item: /signshop price <Price amount> <Price Item>"));
            player.sendMessage((Component)Component.text((String)"Example: /signshop sell 1 diamond"));
            player.sendMessage((Component)Component.text((String)"Example: /signshop price 10 iron_ingot"));
            player.sendMessage((Component)Component.text((String)"Make sure the names of the items are correct.", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        }
        if (args[0].equalsIgnoreCase("sell")) {
            int amount;
            if (args.length < 3) {
                player.sendMessage((Component)Component.text((String)"Usage: /signshop sell <amount> <item>", (TextColor)NamedTextColor.RED));
                return true;
            }
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage((Component)Component.text((String)"Invalid amount!", (TextColor)NamedTextColor.RED));
                return true;
            }
            Material material = Material.matchMaterial((String)args[2]);
            if (material == null) {
                player.sendMessage((Component)Component.text((String)("Invalid item: " + args[2]), (TextColor)NamedTextColor.RED));
                return true;
            }
            ShopConfig config = this.pendingShops.computeIfAbsent(player.getUniqueId(), k -> new ShopConfig());
            config.sellAmount = amount;
            config.sellItem = material;
            player.sendMessage((Component)Component.text((String)("Set shop to sell: " + amount + "x " + material.name()), (TextColor)NamedTextColor.GREEN));
            if (config.isComplete()) {
                player.sendMessage((Component)Component.text((String)"Shop configured! Use wooden hoe to link.", (TextColor)NamedTextColor.YELLOW));
            } else {
                player.sendMessage((Component)Component.text((String)"Now set price: /signshop price <amount> <item>", (TextColor)NamedTextColor.YELLOW));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("price")) {
            int amount;
            if (args.length < 3) {
                player.sendMessage((Component)Component.text((String)"Usage: /signshop price <amount> <item>", (TextColor)NamedTextColor.RED));
                return true;
            }
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage((Component)Component.text((String)"Invalid amount!", (TextColor)NamedTextColor.RED));
                return true;
            }
            Material material = Material.matchMaterial((String)args[2]);
            if (material == null) {
                player.sendMessage((Component)Component.text((String)("Invalid item: " + args[2]), (TextColor)NamedTextColor.RED));
                return true;
            }
            ShopConfig config = this.pendingShops.computeIfAbsent(player.getUniqueId(), k -> new ShopConfig());
            config.priceAmount = amount;
            config.priceItem = material;
            player.sendMessage((Component)Component.text((String)("Set shop price: " + amount + "x " + material.name()), (TextColor)NamedTextColor.GREEN));
            if (config.isComplete()) {
                player.sendMessage((Component)Component.text((String)"Shop configured! Use wooden hoe to link.", (TextColor)NamedTextColor.YELLOW));
            } else {
                player.sendMessage((Component)Component.text((String)"Now set what to sell: /signshop sell <amount> <item>", (TextColor)NamedTextColor.YELLOW));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            this.pendingShops.remove(player.getUniqueId());
            player.sendMessage((Component)Component.text((String)"Cleared shop config.", (TextColor)NamedTextColor.GREEN));
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        ArrayList<Block> fullShops = new ArrayList<Block>();
        for (Map.Entry<Block, ShopData> entry : this.shopRegistry.entrySet()) {
            InventoryHolder holder;
            Block containerBlock;
            BlockState blockState;
            ShopData shop = entry.getValue();
            if (!shop.ownerUuid.equals(player.getUniqueId()) || !((blockState = (containerBlock = shop.containerPos.getBlock()).getState()) instanceof InventoryHolder) || !this.isContainerFull((holder = (InventoryHolder)blockState).getInventory(), shop)) continue;
            fullShops.add(entry.getKey());
        }
        if (!fullShops.isEmpty()) {
            player.sendMessage((Component)Component.text((String)("[Shop Alert] " + fullShops.size() + " shop(s) have full containers!"), (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 0.7f, 1.0f);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Sign sign;
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.WOODEN_HOE) {
            Sign sign2;
            Component firstLine;
            event.setCancelled(true);
            if (block.getState() instanceof InventoryHolder) {
                this.linkingMode.put(player.getUniqueId(), block);
                player.sendMessage((Component)Component.text((String)"Container selected! Right-click shop sign.", (TextColor)NamedTextColor.GREEN));
                return;
            }
            BlockState blockState = block.getState();
            if (blockState instanceof Sign && (firstLine = (sign2 = (Sign)blockState).getSide(Side.FRONT).line(0)).toString().contains("[Shop]")) {
                Block containerBlock = this.linkingMode.get(player.getUniqueId());
                ShopConfig config = this.pendingShops.get(player.getUniqueId());
                if (containerBlock == null) {
                    player.sendMessage((Component)Component.text((String)"Select container first!", (TextColor)NamedTextColor.RED));
                    return;
                }
                if (config == null || !config.isComplete()) {
                    player.sendMessage((Component)Component.text((String)"Configure shop first!", (TextColor)NamedTextColor.RED));
                    return;
                }
                ShopData shopData = new ShopData(config.sellAmount, config.sellItem, config.priceAmount, config.priceItem, containerBlock.getLocation(), player.getUniqueId());
                this.shopRegistry.put(block, shopData);
                this.linkingMode.remove(player.getUniqueId());
                this.pendingShops.remove(player.getUniqueId());
                this.updateSignDisplay(sign2, shopData);
                sign2.setWaxed(true);
                sign2.update();
                this.saveManager.saveShops(this.shopRegistry);
                player.sendMessage((Component)Component.text((String)"Shop created!", (TextColor)NamedTextColor.GREEN));
            }
            return;
        }
        BlockState firstLine = block.getState();
        if (firstLine instanceof Sign && (firstLine = (sign = (Sign)firstLine).getSide(Side.FRONT).line(0)).toString().contains("[Shop]") && this.shopRegistry.containsKey(block)) {
            event.setCancelled(true);
            ShopData shop = this.shopRegistry.get(block);
            this.processPurchase(player, shop, sign);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        this.shopRegistry.remove(block);
        this.shopRegistry.entrySet().removeIf(entry -> ((ShopData)entry.getValue()).containerPos.getBlock().equals((Object)block));
        this.saveManager.saveShops(this.shopRegistry);
    }

    private void updateSignDisplay(Sign sign, ShopData shop) {
        @NotNull SignSide front = sign.getSide(Side.FRONT);
        front.line(1, (Component)Component.text((String)(shop.sellAmount + " " + shop.sellItem.name().toLowerCase().replace("_", " "))));
        front.line(3, (Component)Component.text((String)(shop.priceAmount + " " + shop.priceItem.name().toLowerCase().replace("_", " "))));
        sign.update();
        this.updateSignEffects(sign, shop);
    }

    private void updateSignEffects(Sign sign, ShopData shop) {
        Block containerBlock = shop.containerPos.getBlock();
        BlockState blockState = containerBlock.getState();
        if (!(blockState instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)blockState;
        boolean hasStock = this.hasEnoughItems(holder.getInventory(), shop.sellItem, shop.sellAmount);
        boolean isFull = this.isContainerFull(holder.getInventory(), shop);
        @NotNull SignSide front = sign.getSide(Side.FRONT);
        if (hasStock && !isFull) {
            sign.setGlowingText(true);
            for (int i = 0; i < 4; ++i) {
                front.line(i, front.line(i).color((TextColor)NamedTextColor.BLACK).decorate(TextDecoration.BOLD));
            }
        } else {
            sign.setGlowingText(false);
            for (int i = 0; i < 4; ++i) {
                front.line(i, front.line(i).color((TextColor)NamedTextColor.RED).decorate(TextDecoration.BOLD));
            }
        }
        sign.update();
    }

    private boolean isContainerFull(Inventory inv, ShopData shop) {
        int empty = 0;
        int partial = 0;
        for (ItemStack stack : inv.getStorageContents()) {
            if (stack == null || stack.getType() == Material.AIR) {
                ++empty;
                continue;
            }
            if (stack.getType() != shop.priceItem || stack.getAmount() >= stack.getMaxStackSize()) continue;
            ++partial;
        }
        return empty == 0 && partial == 0;
    }

    private boolean hasInventorySpace(Player player, Material item, int amount) {
        PlayerInventory inv = player.getInventory();
        int remaining = amount;
        for (ItemStack stack : inv.getStorageContents()) {
            if (stack == null || stack.getType() == Material.AIR) {
                remaining -= item.getMaxStackSize();
            } else if (stack.getType() == item) {
                remaining -= stack.getMaxStackSize() - stack.getAmount();
            }
            if (remaining > 0) continue;
            return true;
        }
        return false;
    }

    private void processPurchase(Player player, ShopData shop, Sign sign) {
        Block containerBlock = shop.containerPos.getBlock();
        BlockState blockState = containerBlock.getState();
        if (!(blockState instanceof InventoryHolder)) {
            player.sendMessage((Component)Component.text((String)"Container not found!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            return;
        }
        InventoryHolder holder = (InventoryHolder)blockState;
        Inventory container = holder.getInventory();
        if (!this.hasEnoughItems((Inventory)player.getInventory(), shop.priceItem, shop.priceAmount)) {
            player.sendMessage((Component)Component.text((String)"Can't afford this!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.7f, 1.0f);
            return;
        }
        if (!this.hasEnoughItems(container, shop.sellItem, shop.sellAmount)) {
            player.sendMessage((Component)Component.text((String)"Out of stock!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            this.notifyOwner(shop, "out of stock");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.7f, 1.0f);
            this.updateSignEffects(sign, shop);
            return;
        }
        if (this.isContainerFull(container, shop)) {
            player.sendMessage((Component)Component.text((String)"Container full!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            this.notifyOwner(shop, "container full");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.7f, 1.0f);
            this.updateSignEffects(sign, shop);
            return;
        }
        if (!this.hasInventorySpace(player, shop.sellItem, shop.sellAmount)) {
            player.sendMessage((Component)Component.text((String)"Inventory full!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.7f, 1.0f);
            return;
        }
        this.removeItems((Inventory)player.getInventory(), shop.priceItem, shop.priceAmount);
        this.addItems(container, shop.priceItem, shop.priceAmount);
        this.removeItems(container, shop.sellItem, shop.sellAmount);
        this.addItems((Inventory)player.getInventory(), shop.sellItem, shop.sellAmount);
        player.sendMessage((Component)Component.text((String)"Purchased!", (TextColor)NamedTextColor.GREEN));
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.0f);
        this.updateSignEffects(sign, shop);
    }

    private boolean hasEnoughItems(Inventory inv, Material material, int amount) {
        int count = 0;
        for (ItemStack stack : inv.getStorageContents()) {
            if (stack == null || stack.getType() != material) continue;
            count += stack.getAmount();
        }
        return count >= amount;
    }

    private void removeItems(Inventory inv, Material material, int amount) {
        int remaining = amount;
        for (int i = 0; i < inv.getSize() && remaining > 0; ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.getType() != material) continue;
            int toRemove = Math.min(remaining, stack.getAmount());
            stack.setAmount(stack.getAmount() - toRemove);
            remaining -= toRemove;
        }
    }

    private void addItems(Inventory inv, Material material, int amount) {
        inv.addItem(new ItemStack[]{new ItemStack(material, amount)});
    }

    private void notifyOwner(ShopData shop, String reason) {
        Player owner = Bukkit.getPlayer((UUID)shop.ownerUuid);
        if (owner != null && owner.isOnline()) {
            if (reason.equals("out of stock")) {
                owner.sendMessage((Component)Component.text((String)"[Shop Alert] Out of stock!", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            } else {
                owner.sendMessage((Component)Component.text((String)"[Shop Alert] Container full!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            }
            owner.playSound(owner.getLocation(), Sound.UI_STONECUTTER_SELECT_RECIPE, 0.7f, 1.0f);
        }
    }

    public static class ShopData {
        int sellAmount;
        Material sellItem;
        int priceAmount;
        Material priceItem;
        Location containerPos;
        UUID ownerUuid;

        public ShopData(int sellAmount, Material sellItem, int priceAmount, Material priceItem, Location containerPos, UUID ownerUuid) {
            this.sellAmount = sellAmount;
            this.sellItem = sellItem;
            this.priceAmount = priceAmount;
            this.priceItem = priceItem;
            this.containerPos = containerPos;
            this.ownerUuid = ownerUuid;
        }
    }

    public static class ShopConfig {
        int sellAmount = 0;
        Material sellItem = null;
        int priceAmount = 0;
        Material priceItem = null;

        boolean isComplete() {
            return this.sellItem != null && this.priceItem != null && this.sellAmount > 0 && this.priceAmount > 0;
        }
    }
}

