/*
 * Decompiled with CFR 0.152.
 */
package io.github.glxyarcane.signShopPaper;

import io.github.glxyarcane.signShopPaper.SignShopPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;

public class SignShopSaveManager {
    private final SignShopPlugin plugin;
    private final File dataFile;

    public SignShopSaveManager(SignShopPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "shops.yml");
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
    }

    public void saveShops(Map<Block, SignShopPlugin.ShopData> shops) {
        YamlConfiguration config = new YamlConfiguration();
        int index = 0;
        for (Map.Entry<Block, SignShopPlugin.ShopData> entry : shops.entrySet()) {
            Block signBlock = entry.getKey();
            SignShopPlugin.ShopData shop = entry.getValue();
            String path = "shops." + index;
            config.set(path + ".sign.world", (Object)signBlock.getWorld().getName());
            config.set(path + ".sign.x", (Object)signBlock.getX());
            config.set(path + ".sign.y", (Object)signBlock.getY());
            config.set(path + ".sign.z", (Object)signBlock.getZ());
            config.set(path + ".sellAmount", (Object)shop.sellAmount);
            config.set(path + ".sellItem", (Object)shop.sellItem.name());
            config.set(path + ".priceAmount", (Object)shop.priceAmount);
            config.set(path + ".priceItem", (Object)shop.priceItem.name());
            config.set(path + ".container.world", (Object)shop.containerPos.getWorld().getName());
            config.set(path + ".container.x", (Object)shop.containerPos.getBlockX());
            config.set(path + ".container.y", (Object)shop.containerPos.getBlockY());
            config.set(path + ".container.z", (Object)shop.containerPos.getBlockZ());
            config.set(path + ".owner", (Object)shop.ownerUuid.toString());
            ++index;
        }
        try {
            config.save(this.dataFile);
            this.plugin.getLogger().info("Saved " + shops.size() + " shops");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save shops: " + e.getMessage());
        }
    }

    public void loadShops(Map<Block, SignShopPlugin.ShopData> shops) {
        if (!this.dataFile.exists()) {
            this.plugin.getLogger().info("No existing shop data found");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (!config.contains("shops")) {
            return;
        }
        int loaded = 0;
        for (String key : config.getConfigurationSection("shops").getKeys(false)) {
            String path = "shops." + key;
            try {
                World signWorld = Bukkit.getWorld((String)config.getString(path + ".sign.world"));
                if (signWorld == null) continue;
                int signX = config.getInt(path + ".sign.x");
                int signY = config.getInt(path + ".sign.y");
                int signZ = config.getInt(path + ".sign.z");
                Block signBlock = signWorld.getBlockAt(signX, signY, signZ);
                World containerWorld = Bukkit.getWorld((String)config.getString(path + ".container.world"));
                if (containerWorld == null) continue;
                int containerX = config.getInt(path + ".container.x");
                int containerY = config.getInt(path + ".container.y");
                int containerZ = config.getInt(path + ".container.z");
                Location containerLoc = new Location(containerWorld, (double)containerX, (double)containerY, (double)containerZ);
                int sellAmount = config.getInt(path + ".sellAmount");
                Material sellItem = Material.valueOf((String)config.getString(path + ".sellItem"));
                int priceAmount = config.getInt(path + ".priceAmount");
                Material priceItem = Material.valueOf((String)config.getString(path + ".priceItem"));
                UUID owner = UUID.fromString(config.getString(path + ".owner"));
                SignShopPlugin.ShopData shop = new SignShopPlugin.ShopData(sellAmount, sellItem, priceAmount, priceItem, containerLoc, owner);
                shops.put(signBlock, shop);
                ++loaded;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load shop " + key + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Loaded " + loaded + " shops");
    }
}

