/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.searchr.mixin;

import dev.cerus.searchr.Searchr;
import dev.cerus.searchr.config.KeyBinds;
import dev.cerus.searchr.config.ModConfig;
import dev.cerus.searchr.interfaces.Configurable;
import dev.cerus.searchr.interfaces.Searchable;
import dev.cerus.searchr.search.HistorySearch;
import dev.cerus.searchr.search.SimpleHistorySearch;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_408.class})
public class ChatScreenMixin
extends class_437
implements Searchable {
    @Shadow
    private class_342 field_2382;
    @Shadow
    private class_4717 field_21616;
    private ModConfig config;
    private HistorySearch historySearch;
    private boolean searchEnabled;
    private String latestSuggestion;
    private int offset;

    protected ChatScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void injectInit(CallbackInfo ci) {
        this.config = Searchr.getConfig();
        this.historySearch = new SimpleHistorySearch(class_310.method_1551());
        ((Configurable)this.field_2382).setConfig(this.config);
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyInput;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectOnKeyPress(class_11908 keyInput, CallbackInfoReturnable<Boolean> ci) {
        int keyCode = keyInput.comp_4795();
        if (KeyBinds.ACTIVATE.wasPressed(keyInput)) {
            if (!this.isSearchEnabled()) {
                this.enableSearch();
            } else {
                ++this.offset;
                this.updateSuggestion(this.field_2382.method_1882());
            }
            ci.setReturnValue((Object)true);
        } else if (this.shouldExit(keyInput) && this.isSearchEnabled()) {
            this.disableSearch();
            this.field_2382.method_1852("");
            ci.setReturnValue((Object)true);
        } else if ((keyCode == 258 || keyCode == 257) && this.isSearchEnabled()) {
            this.disableSearch();
            if (this.latestSuggestion != null) {
                this.field_2382.method_1852(this.latestSuggestion);
            }
            this.field_2382.method_1872(false);
            ci.setReturnValue((Object)true);
        }
    }

    private boolean shouldExit(class_11908 keyInput) {
        int keyCode = keyInput.comp_4795();
        boolean ctrlC = this.config.keys.allowCtrlC && keyCode == 67 && keyInput.method_74240();
        boolean normalExit = keyCode == 256;
        return normalExit || ctrlC;
    }

    @Inject(method={"removed()V"}, at={@At(value="HEAD")})
    public void injectOnRemove(CallbackInfo ci) {
        this.disableSearch();
    }

    @Inject(method={"onChatFieldUpdate(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void injectOnChatFieldUpdate(String chatText, CallbackInfo ci) {
        this.offset = 0;
        this.updateSuggestion(chatText);
    }

    private void updateSuggestion(String txt) {
        if (this.isSearchEnabled() && this.historySearch != null) {
            this.latestSuggestion = this.historySearch.searchHistory(txt, this.offset);
            this.setSuggestion(this.latestSuggestion);
        }
    }

    @Override
    public void setSuggestion(String suggestion) {
        ((Searchable)this.field_2382).setSuggestion(suggestion);
    }

    @Override
    public void enableSearch() {
        this.searchEnabled = true;
        this.field_2382.method_1852("");
        this.offset = 0;
        ((Searchable)this.field_2382).enableSearch();
        ((Searchable)this.field_21616).enableSearch();
        this.latestSuggestion = null;
    }

    @Override
    public void disableSearch() {
        this.searchEnabled = false;
        ((Searchable)this.field_2382).disableSearch();
        ((Searchable)this.field_21616).disableSearch();
    }

    @Override
    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }
}

