/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.searchr.mixin;

import dev.cerus.searchr.config.ModConfig;
import dev.cerus.searchr.interfaces.Configurable;
import dev.cerus.searchr.interfaces.Searchable;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_342.class})
public abstract class TextFieldWidgetMixin
extends class_339
implements Searchable,
Configurable {
    private static final int MASK = -16777216;
    @Shadow
    private class_327 field_2105;
    @Shadow
    private String field_2092;
    @Shadow
    private int field_60436;
    private ModConfig config;
    private boolean searchEnabled;
    private String textLower;
    private String suggestion;
    private String suggestionLower;

    public TextFieldWidgetMixin(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    @Shadow
    public abstract void method_1870(boolean var1);

    @Shadow
    public abstract void method_1872(boolean var1);

    @Inject(method={"renderWidget(Lnet/minecraft/client/gui/DrawContext;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectOnRenderWidget(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci, int $$5, int $$6, String $$7, boolean $$8, boolean $$9, int $$10) {
        if (this.searchEnabled) {
            int posX = $$10;
            int posY = this.field_60436;
            if (this.suggestion == null) {
                if (this.field_2092.isEmpty()) {
                    context.method_27535(this.field_2105, (class_2561)class_2561.method_43471((String)"text.searchr.typeToSearch"), posX, posY, this.config.colors.colorPlaceholder | 0xFF000000);
                } else {
                    class_5250 infoText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"text.searchr.notFound")).method_27693(" ");
                    context.method_27535(this.field_2105, (class_2561)infoText, posX, posY, this.config.colors.colorNotFoundPrefix | 0xFF000000);
                    context.method_25303(this.field_2105, this.field_2092, posX + 1 + this.field_2105.method_27525((class_5348)infoText), posY, this.config.colors.colorNotFoundSuffix | 0xFF000000);
                }
            } else {
                context.method_25303(this.field_2105, this.suggestion, posX, posY, this.config.colors.colorSearch | 0xFF000000);
                if (this.field_2092 != null && !this.field_2092.isBlank()) {
                    int start = this.suggestionLower.indexOf(this.textLower);
                    if (start < 0) {
                        return;
                    }
                    int startOffset = this.field_2105.method_1727(this.suggestion.substring(0, start)) + posX;
                    int lineWidth = this.field_2105.method_1727(this.field_2092);
                    Objects.requireNonNull(this.field_2105);
                    context.method_51738(startOffset, startOffset + lineWidth, posY + 9, this.config.colors.colorSearchHighlight | 0xFF000000);
                }
            }
        }
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyInput;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectOnKeyPressed(class_11908 keyInput, CallbackInfoReturnable<Boolean> ci) {
        int keyCode = keyInput.comp_4795();
        if (this.isSearchEnabled() && (keyCode == 263 || keyCode == 262 || keyCode == 268 || keyCode == 269 || keyInput.method_74241() || keyInput.method_74243())) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onChanged(Ljava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectOnChanged(String text, CallbackInfo ci) {
        this.textLower = text.toLowerCase();
    }

    @Redirect(method={"renderWidget(Lnet/minecraft/client/gui/DrawContext;IIF)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;isEmpty()Z"))
    private boolean proxyStringEmpty(String obj) {
        if (this.isSearchEnabled()) {
            return true;
        }
        return obj.isEmpty();
    }

    @Redirect(method={"renderWidget(Lnet/minecraft/client/gui/DrawContext;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;isFocused()Z", ordinal=1))
    private boolean proxyIsFocused(class_342 obj) {
        return !this.isSearchEnabled() && obj.method_25370();
    }

    @Override
    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
        this.suggestionLower = suggestion == null ? null : suggestion.toLowerCase();
    }

    @Override
    public void enableSearch() {
        this.searchEnabled = true;
        this.textLower = null;
        this.method_1872(false);
    }

    @Override
    public void disableSearch() {
        this.searchEnabled = false;
        this.setSuggestion(null);
        this.method_1870(false);
    }

    @Override
    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    @Override
    public void setConfig(ModConfig config) {
        this.config = config;
    }
}

