/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.theblackcat.endurance.damage_types.EnduranceDamageTypes;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.enchantments.EnduranceEnchantmentEffects;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IEffectInstance;
import net.theblackcat.endurance.potions.EndurancePotions;
import net.theblackcat.endurance.status_effects.EnduranceStatusEffects;
import net.theblackcat.endurance.tracked_data.ModTrackedDataHandlers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endurance
implements ModInitializer {
    public static final String MOD_ID = "endurance";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"endurance");

    public void onInitialize() {
        EnduranceStatusEffects.Initialise();
        EnduranceDamageTypes.Initialise();
        EnduranceEnchantmentEffects.Initialise();
        EnduranceDataComponents.Initialise();
        EndurancePotions.Initialise();
        ModTrackedDataHandlers.Register();
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, source, amount) -> {
            int level;
            class_1799 chest;
            IEffectInstance instance;
            if (!(entity instanceof class_3222)) {
                return true;
            }
            class_3222 player = (class_3222)entity;
            class_1293 endurance = player.method_6112(EnduranceStatusEffects.ENDURANCE);
            if (endurance == null || player.method_6059(EnduranceStatusEffects.DEEP_WOUND)) {
                return true;
            }
            if (endurance instanceof IEffectInstance && (instance = (IEffectInstance)endurance).GetSourceStack().method_31573(class_3489.field_48301) && !(chest = player.method_6118(class_1304.field_6174)).method_7960() && (level = EnduranceEnchantmentEffects.GetLevel((class_1937)player.method_51469(), EnduranceEnchantmentEffects.UNDYING, chest)) > 0) {
                int cooldown = 3000 - (level - 1) * 600;
                chest.method_57379(EnduranceDataComponents.UNDYING_COOLDOWN, (Object)cooldown);
                chest.method_7956(EnduranceHelper.GetUndyingDamage((class_1937)player.method_51469(), chest), player.method_51469(), player, item -> {});
            }
            player.method_6033(1.0f);
            player.method_6016(EnduranceStatusEffects.ENDURANCE);
            player.method_6092(new class_1293(EnduranceStatusEffects.DEEP_WOUND, -1, endurance.method_5578(), false, true, true));
            return false;
        });
        FabricBrewingRecipeRegistryBuilder.BUILD.register(EndurancePotions::BuildRecipe);
    }

    public static class_2960 Id(String id) {
        return class_2960.method_60655((String)MOD_ID, (String)id);
    }
}

