/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_9848;
import net.theblackcat.endurance.Endurance;
import net.theblackcat.endurance.config.ModConfig;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IPlayerEntity;
import org.spongepowered.asm.mixin.Unique;

public class EnduranceClient
implements ClientModInitializer {
    @Unique
    private static final class_2960 BLOOD_VIGNETTE = class_2960.method_60656((String)"textures/misc/vignette.png");
    private float finalAlpha = 0.0f;

    public void onInitializeClient() {
        ItemTooltipCallback.EVENT.register((stack, context, type, list) -> {
            if (stack.method_31573(class_3489.field_48296)) {
                Integer cd = (Integer)stack.method_58695(EnduranceDataComponents.UNDYING_COOLDOWN, (Object)-1);
                if (cd > 0) {
                    float totalSec = (float)cd.intValue() / 20.0f;
                    int min = (int)(totalSec / 60.0f);
                    int sec = (int)(totalSec % 60.0f);
                    list.add(class_2561.method_43473());
                    list.add(class_2561.method_43469((String)"item.endurance.undying_cooldown.tooltip", (Object[])new Object[]{min, sec < 10 ? "0" + sec : String.valueOf(sec)}));
                } else if (cd == 0) {
                    class_5250 txt = class_2561.method_43473();
                    txt.method_10852((class_2561)class_2561.method_43471((String)"item.endurance.undying_cooldown.activated.tooltip"));
                    if (stack.method_7919() + EnduranceHelper.GetUndyingDamage((class_1937)class_310.method_1551().field_1687, stack) >= stack.method_7936()) {
                        txt.method_10852((class_2561)class_2561.method_43471((String)"item.endurance.undying.will_break.tooltip").method_27692(class_124.field_1061));
                    }
                    list.add(class_2561.method_43473());
                    list.add(txt);
                }
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, access) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"endurance").then(ClientCommandManager.literal((String)"showVignette").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            try {
                ModConfig.Instance().SetShowVignette(enabled);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Showing vignette is " + (enabled ? "enabled" : "disabled"))));
            return 1;
        })))));
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.HOTBAR, (class_2960)Endurance.Id("blood_vignette"), (context, tickCounter) -> {
            class_310 client = class_310.method_1551();
            try {
                class_746 patt0$temp = client.field_1724;
                if (patt0$temp instanceof IPlayerEntity) {
                    IPlayerEntity player = (IPlayerEntity)patt0$temp;
                    if (ModConfig.Instance().ShouldShowVignette() && (player.GetInjuredTime() > 0 || player.GetRemovedInjuriesTime() > 0 && player.GetRemovedInjuriesTime() < 30)) {
                        float alpha;
                        if (player.HasDeepWound()) {
                            alpha = class_3532.method_16439((float)Math.clamp((float)player.GetInjuredTime() / 10.0f, 0.0f, 1.0f), (float)0.0f, (float)0.3f);
                            alpha += class_3532.method_16439((float)(player.GetTemporaryHealth() / 20.0f), (float)0.5f, (float)0.0f);
                        } else {
                            alpha = class_3532.method_16439((float)Math.clamp((float)player.GetRemovedInjuriesTime() / 30.0f, 0.0f, 1.0f), (float)this.finalAlpha, (float)0.0f);
                        }
                        int i = class_9848.method_61324((int)((int)(alpha * 255.0f)), (int)136, (int)8, (int)8);
                        context.method_25291(class_10799.field_56883, BLOOD_VIGNETTE, 0, 0, 0.0f, 0.0f, context.method_51421(), context.method_51443(), context.method_51421(), context.method_51443(), i);
                        this.finalAlpha = alpha;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

