/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private boolean showVignette = true;
    private static ModConfig instance;

    public ModConfig() throws IOException {
        if (ModConfig.GetFile().createNewFile()) {
            this.Save();
        } else {
            this.Read();
        }
    }

    public boolean ShouldShowVignette() {
        return this.showVignette;
    }

    public void SetShowVignette(boolean show) {
        this.showVignette = show;
    }

    public static ModConfig Instance() throws IOException {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    private static File GetFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("endurance-config.txt").toFile();
    }

    private void Save() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ModConfig.GetFile()), StandardCharsets.UTF_8));){
            writer.write(String.valueOf(this.showVignette));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void Read() {
        try (BufferedReader reader = new BufferedReader(new FileReader(ModConfig.GetFile()));){
            this.showVignette = Boolean.parseBoolean(reader.readLine());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

