/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance.helpers;

import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.enchantments.EnduranceEnchantmentEffects;
import net.theblackcat.endurance.interfaces.IEffectInstance;
import net.theblackcat.endurance.status_effects.EnduranceStatusEffects;

public class EnduranceHelper {
    public static int GetBorrowedLifeLevel(class_1937 world, class_1799 stack) {
        return EnduranceEnchantmentEffects.GetLevel(world, EnduranceEnchantmentEffects.BORROWED_LIFE, stack);
    }

    public static int GetUndyingLevel(class_1937 world, class_1799 stack) {
        return EnduranceEnchantmentEffects.GetLevel(world, EnduranceEnchantmentEffects.UNDYING, stack);
    }

    public static int GetUndyingDamage(class_1937 world, class_1799 stack) {
        int level = EnduranceHelper.GetUndyingLevel(world, stack);
        if (level > 0) {
            return (int)((float)stack.method_7936() * (0.1f - 0.01f * (float)(level - 1)));
        }
        return 0;
    }

    public static void ApplyBorrowedLife(class_1799 stack, int level) {
        if (level < 0 || level > 3) {
            return;
        }
        stack.method_57379(EnduranceDataComponents.BORROWED_LIFE_MAX_TOKEN, (Object)(20 - 2 * (level - 1)));
        EnduranceHelper.SetToken(stack, EnduranceHelper.GetToken(stack));
    }

    public static void TryTriggerBorrowedLife(class_1657 player, class_1799 stack) {
        int level = EnduranceHelper.GetBorrowedLifeLevel(player.method_37908(), stack);
        if (level > 0 && EnduranceHelper.GetToken(stack) >= EnduranceHelper.GetMaxToken(stack)) {
            class_1293 instance = new class_1293(EnduranceStatusEffects.ENDURANCE, 120, level - 1, false, true, true);
            ((IEffectInstance)instance).SetSourceStack(stack);
            player.method_6092(instance);
            EnduranceHelper.SetToken(stack, 0);
        }
    }

    public static void SetToken(class_1799 stack, int token) {
        stack.method_57379(EnduranceDataComponents.BORROWED_LIFE_TOKEN, (Object)Math.clamp((long)token, 0, EnduranceHelper.GetMaxToken(stack)));
    }

    public static int GetToken(class_1799 stack) {
        return (Integer)stack.method_58695(EnduranceDataComponents.BORROWED_LIFE_TOKEN, (Object)0);
    }

    public static int GetMaxToken(class_1799 stack) {
        return (Integer)stack.method_58695(EnduranceDataComponents.BORROWED_LIFE_MAX_TOKEN, (Object)0);
    }
}

