/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance.mixin;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.theblackcat.endurance.Endurance;
import net.theblackcat.endurance.damage_types.EnduranceDamageTypes;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.enchantments.EnduranceEnchantmentEffects;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IEffectInstance;
import net.theblackcat.endurance.interfaces.IPlayerEntity;
import net.theblackcat.endurance.status_effects.EnduranceStatusEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements IPlayerEntity {
    @Unique
    private static final class_2940<Float> TEMPORARY_HEALTH = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Float> MENDING_PROGRESS = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Integer> PAUSE_DEDUCTION_TICK = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);
    @Unique
    private float tickToDuction = 0.0f;
    @Unique
    private int tickToMend = 0;
    @Unique
    private int tickToLoseMend = 0;
    @Unique
    private int damagedWhileDeepWoundTime = 0;
    @Unique
    private int appliedDeepWoundTime = 0;
    @Unique
    private int removedDeepWoundTime = 0;
    @Unique
    private class_243 prevPos = class_243.field_1353;
    @Unique
    private class_1657 self;

    @Inject(method={"<init>(Lnet/minecraft/class_1937;Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void Initialise(class_1937 world, GameProfile profile, CallbackInfo info) {
        this.self = (class_1657)this;
    }

    @Inject(method={"method_5693(Lnet/minecraft/class_2945$class_9222;)V"}, at={@At(value="TAIL")})
    private void InitCustomData(class_2945.class_9222 builder, CallbackInfo info) {
        builder.method_56912(TEMPORARY_HEALTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(MENDING_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(PAUSE_DEDUCTION_TICK, (Object)0);
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void Tick(CallbackInfo info) {
        class_1937 class_19372 = this.self.method_37908();
        if (class_19372 instanceof class_3218) {
            IEffectInstance instance;
            class_1293 endurance;
            boolean offCooldown;
            class_3218 world = (class_3218)class_19372;
            class_1799 chest = this.self.method_6118(class_1304.field_6174);
            int lvl = EnduranceEnchantmentEffects.GetLevel((class_1937)world, EnduranceEnchantmentEffects.UNDYING, chest);
            boolean hasUndying = !chest.method_7960() && chest.method_31573(class_3489.field_48296) && lvl > 0;
            boolean bl = offCooldown = (Integer)chest.method_58695(EnduranceDataComponents.UNDYING_COOLDOWN, (Object)-1) == 0;
            if (hasUndying && offCooldown) {
                if (!this.self.method_6059(EnduranceStatusEffects.ENDURANCE) && !this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND)) {
                    endurance = new class_1293(EnduranceStatusEffects.ENDURANCE, -1, lvl - 1, false, true, true);
                    ((IEffectInstance)endurance).SetSourceStack(chest);
                    this.self.method_6092(endurance);
                }
            } else if (this.self.method_6059(EnduranceStatusEffects.ENDURANCE) && (endurance = this.self.method_6112(EnduranceStatusEffects.ENDURANCE)) instanceof IEffectInstance && EnduranceHelper.GetUndyingLevel((class_1937)world, (instance = (IEffectInstance)endurance).GetSourceStack()) > 0) {
                this.self.method_6016(EnduranceStatusEffects.ENDURANCE);
            }
            if (this.HasDeepWound()) {
                if (this.GetTrackedData(PAUSE_DEDUCTION_TICK) <= 0) {
                    boolean bl2 = this.self.method_5624() || this.self.method_6030().method_7976() == class_1839.field_8950 || this.self.method_6030().method_7976() == class_1839.field_8946;
                    float deduct = bl2 ? 0.4f : 1.0f;
                    deduct = this.damagedWhileDeepWoundTime > 0 ? deduct * 1.5f : deduct;
                    this.tickToDuction -= deduct;
                    if (this.tickToDuction <= 0.0f) {
                        ((class_1291)this.self.method_6112(EnduranceStatusEffects.DEEP_WOUND).method_5579().comp_349()).method_5572(world, (class_1309)this.self, 0);
                        this.tickToDuction = this.GetTimeRequiredToBleed();
                    }
                } else {
                    this.IncrementTrackedInt(PAUSE_DEDUCTION_TICK, -1);
                }
                if (this.GetTemporaryHealth() < 1.0f) {
                    this.SetTemporaryHealth(0.0f);
                    this.self.method_64397(world, EnduranceDamageTypes.GetSource((class_1937)world, EnduranceDamageTypes.DEEP_WOUND_DAMAGE), Float.MAX_VALUE);
                }
                if (this.CanRecoverDeepWound()) {
                    ++this.tickToMend;
                    if (this.tickToMend >= this.GetTimeRequiredToMend()) {
                        this.AddMendingProgress(1.0f);
                        this.tickToMend = 0;
                    }
                } else {
                    this.tickToMend = 0;
                }
                if (this.tickToLoseMend > 0) {
                    --this.tickToLoseMend;
                    if (this.tickToLoseMend <= 0) {
                        this.AddMendingProgress(-1.0f);
                        this.tickToLoseMend = 10;
                    }
                }
                this.prevPos = this.self.method_19538();
            }
        } else if (this.HasDeepWound()) {
            this.removedDeepWoundTime = 0;
            ++this.appliedDeepWoundTime;
        } else if (this.removedDeepWoundTime < 30) {
            ++this.removedDeepWoundTime;
        }
    }

    @Inject(method={"method_7324(Lnet/minecraft/class_1297;)V"}, at={@At(value="TAIL")})
    private void PauseOnAttacked(class_1297 target, CallbackInfo info) {
        if (!(target instanceof class_1296)) {
            this.PauseDeduction();
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="RETURN")})
    private void PauseOnDamaged(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source.method_5526() != null && ((Boolean)info.getReturnValue()).booleanValue()) {
            this.PauseDeduction();
        }
    }

    @Inject(method={"method_6074(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1657;method_5679(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void DamageDeepWound(class_3218 world, class_1282 source, float amount, CallbackInfo info) {
        if (this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND) && !source.method_49708(EnduranceDamageTypes.DEEP_WOUND_DAMAGE)) {
            int time = this.damagedWhileDeepWoundTime;
            if (time == 0) {
                this.IncrementTrackedFloat(TEMPORARY_HEALTH, -amount);
            } else if (time == 1) {
                this.SetTemporaryHealth(this.GetTemporaryHealth() * 0.5f);
            } else {
                return;
            }
            ++this.damagedWhileDeepWoundTime;
            info.cancel();
        }
    }

    @Inject(method={"method_6074(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)V"}, at={@At(value="TAIL")})
    private void RemoveShield(class_3218 world, class_1282 source, float amount, CallbackInfo info) {
        if (this.self.method_6067() <= 0.0f) {
            this.self.method_5996(class_5134.field_45124).method_6200(Endurance.Id("effect.deep_wound.removed"));
        }
        if (this.self.method_6032() <= 5.0f || this.self.method_29504()) {
            EnduranceHelper.TryTriggerBorrowedLife(this.self, this.self.method_59958());
        }
    }

    @Inject(method={"method_5874(Lnet/minecraft/class_3218;Lnet/minecraft/class_1309;)Z"}, at={@At(value="RETURN")})
    private void ApplyEnduranceOnKilledOther(class_3218 world, class_1309 other, CallbackInfoReturnable<Boolean> info) {
        class_1799 stack = this.self.method_59958();
        if (((Boolean)info.getReturnValue()).booleanValue() && EnduranceHelper.GetBorrowedLifeLevel((class_1937)world, stack) > 0) {
            int increment = other instanceof class_1296 ? 1 : 2;
            increment = this.self.method_6059(EnduranceStatusEffects.ENDURANCE) || this.HasDeepWound() ? increment - 1 : increment;
            EnduranceHelper.SetToken(stack, EnduranceHelper.GetToken(stack) + increment);
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void SaveData(class_11372 view, CallbackInfo info) {
        view.method_71464("temp_hp", this.GetTemporaryHealth());
        view.method_71464("healed_temp_hp", (float)this.GetMendedProgress());
        view.method_71465("pause_deduction", this.GetTrackedData(PAUSE_DEDUCTION_TICK).intValue());
        view.method_71464("tick_to_deduction", this.tickToDuction);
        view.method_71465("tick_to_recover", this.tickToMend);
        view.method_71465("tick_to_lose_mend", this.tickToLoseMend);
        view.method_71465("damaged_while_deep_wound", this.damagedWhileDeepWoundTime);
        view.method_71468("prev_pos", class_243.field_38277, (Object)this.prevPos);
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void ReadData(class_11368 view, CallbackInfo info) {
        this.SetTemporaryHealth(view.method_71423("temp_hp", 0.0f));
        this.SetTrackedData(MENDING_PROGRESS, Float.valueOf(view.method_71423("healed_temp_hp", 0.0f)));
        this.SetTrackedData(PAUSE_DEDUCTION_TICK, view.method_71424("pause_deduction", 0));
        this.tickToDuction = view.method_71423("tick_to_deduction", 0.0f);
        this.tickToMend = view.method_71424("tick_to_recover", 0);
        this.tickToLoseMend = view.method_71424("tick_to_lose_mend", 0);
        this.damagedWhileDeepWoundTime = view.method_71424("damaged_while_deep_wound", 0);
        this.prevPos = view.method_71426("prev_pos", class_243.field_38277).orElse(class_243.field_1353);
    }

    @Override
    public void OnAppliedDeepWound() {
        List<class_1293> effects = List.copyOf(this.self.method_6026());
        for (class_1293 effect : effects) {
            if (effect.method_5579().method_40225((class_5321)EnduranceStatusEffects.DEEP_WOUND.method_40230().get())) continue;
            this.self.method_6016(effect.method_5579());
        }
        this.self.method_5996(class_5134.field_45124).method_6203();
        this.self.method_6073(0.0f);
        this.SetTemporaryHealth(20.0f);
        this.SetTrackedData(MENDING_PROGRESS, Float.valueOf(0.0f));
        this.tickToDuction = this.GetTimeRequiredToBleed();
        this.SetTrackedData(PAUSE_DEDUCTION_TICK, 0);
        this.tickToMend = 0;
        this.tickToLoseMend = 0;
        this.damagedWhileDeepWoundTime = 0;
    }

    @Override
    public void OnRemovedDeepWound() {
        if (this.GetTemporaryHealth() > 0.0f && this.self.method_6032() > this.GetTemporaryHealth()) {
            this.self.method_6033(this.GetTemporaryHealth());
        }
    }

    @Override
    public float GetTemporaryHealth() {
        return this.GetTrackedData(TEMPORARY_HEALTH).floatValue();
    }

    @Override
    public void SetTemporaryHealth(float thp) {
        this.SetTrackedData(TEMPORARY_HEALTH, Float.valueOf(Math.clamp(thp, 0.0f, 20.0f)));
    }

    @Override
    public void AddMendingProgress(float thp) {
        this.SetTrackedData(MENDING_PROGRESS, Float.valueOf(Math.clamp(this.GetTrackedData(MENDING_PROGRESS).floatValue() + thp, 0.0f, 20.0f)));
        if (this.GetMendedProgress() >= 20) {
            this.RemoveDeepWound();
        } else if (thp > 0.0f) {
            this.tickToLoseMend = 80;
            this.PauseDeduction();
        } else if (this.GetMendedProgress() <= 0) {
            this.tickToLoseMend = 0;
        }
    }

    @Override
    public boolean LossPaused() {
        return this.HasDeepWound() && this.GetTrackedData(PAUSE_DEDUCTION_TICK) > 0;
    }

    @Override
    public boolean HasDeepWound() {
        return this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND);
    }

    @Override
    public float GetHealRate() {
        return this.self.method_5715() ? 1.2f : 0.75f;
    }

    @Override
    public int GetMendedProgress() {
        return Math.round(this.GetTrackedData(MENDING_PROGRESS).floatValue());
    }

    @Override
    public int GetInjuredTime() {
        return this.appliedDeepWoundTime;
    }

    @Override
    public int GetRemovedInjuriesTime() {
        return this.removedDeepWoundTime;
    }

    @Unique
    private int GetTimeRequiredToBleed() {
        if (!this.HasDeepWound()) {
            return -1;
        }
        int lvl = this.self.method_6112(EnduranceStatusEffects.DEEP_WOUND).method_5578();
        return 20 - 2 * lvl;
    }

    @Unique
    private int GetTimeRequiredToMend() {
        if (!this.HasDeepWound()) {
            return -1;
        }
        int lvl = this.self.method_6112(EnduranceStatusEffects.DEEP_WOUND).method_5578();
        return 5 - lvl;
    }

    @Unique
    private void PauseDeduction() {
        if (this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND)) {
            this.SetTrackedData(PAUSE_DEDUCTION_TICK, 40);
        }
    }

    @Unique
    private void RemoveDeepWound() {
        this.self.method_6016(EnduranceStatusEffects.DEEP_WOUND);
        float shield = Math.max(3.0f, this.GetTemporaryHealth() * 0.3f);
        class_2960 id = Endurance.Id("effect.deep_wound.removed");
        class_1324 instance = this.self.method_5996(class_5134.field_45124);
        if (!instance.method_6196(id) || instance.method_6199(id).comp_2449() < (double)shield) {
            instance.method_61163(new class_1322(id, (double)shield, class_1322.class_1323.field_6328));
            this.self.method_6073(this.self.method_6067() + shield);
        }
        this.SetTemporaryHealth(0.0f);
        this.SetTrackedData(MENDING_PROGRESS, Float.valueOf(0.0f));
        this.self.method_6092(new class_1293(class_1294.field_5924, 60, 3, false, true, true));
        this.self.method_6092(new class_1293(class_1294.field_5904, 60, 0, false, true, true));
    }

    @Unique
    private <T> T GetTrackedData(class_2940<T> data) {
        return (T)this.self.method_5841().method_12789(data);
    }

    @Unique
    private <T> void SetTrackedData(class_2940<T> data, T value) {
        this.self.method_5841().method_12778(data, value);
    }

    @Unique
    private void IncrementTrackedFloat(class_2940<Float> data, float amount) {
        this.SetTrackedData(data, Float.valueOf(this.GetTrackedData(data).floatValue() + amount));
    }

    @Unique
    private void IncrementTrackedInt(class_2940<Integer> data, int amount) {
        this.SetTrackedData(data, this.GetTrackedData(data) + amount);
    }

    @Unique
    private boolean CanRecoverDeepWound() {
        return this.self.method_5715() && !this.IsMoving();
    }

    @Unique
    private boolean IsMoving() {
        return this.self.method_19538().method_1022(this.prevPos) > 0.0;
    }
}

