/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.theblackcat.duskywisplibrary.attributes.DuskyWispAttributes;
import net.theblackcat.duskywisplibrary.data_component_types.Cooldown;
import net.theblackcat.endurance.Endurance;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IEffectInstance;
import net.theblackcat.endurance.interfaces.IPlayerEntity;
import net.theblackcat.endurance.status_effects.EnduranceStatusEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Unique
    private class_1309 self;
    @Unique
    private static final Codec<HashMap<class_6880<class_1291>, class_1799>> ITEM_MAP_CODEC = Codec.unboundedMap((Codec)class_7923.field_41174.method_40294(), (Codec)class_1799.field_24671).xmap(HashMap::new, Map::copyOf);

    @Inject(method={"<init>(Lnet/minecraft/class_1299;Lnet/minecraft/class_1937;)V"}, at={@At(value="TAIL")})
    private void construct(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo ci) {
        this.self = (class_1309)this;
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo info) {
        class_1937 class_19372 = this.self.method_37908();
        if (class_19372 instanceof class_3218) {
            IEffectInstance instance;
            class_1293 endurance;
            class_3218 world = (class_3218)class_19372;
            class_1799 chest = this.self.method_6118(class_1304.field_6174);
            int lvl = EnduranceHelper.getUndyingLevel((class_1937)world, chest);
            boolean hasUndying = !chest.method_7960() && chest.method_31573(class_3489.field_48301) && lvl > 0;
            boolean offCooldown = ((Cooldown)chest.method_58695(EnduranceDataComponents.UNDYING_COOLDOWN, (Object)Cooldown.EMPTY)).isExpired((class_1937)world);
            if (hasUndying && offCooldown) {
                if (!this.self.method_6059(EnduranceStatusEffects.ENDURANCE) && !this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND)) {
                    class_1293 endurance2 = new class_1293(EnduranceStatusEffects.ENDURANCE, -1, lvl - 1, false, true, true);
                    ((IEffectInstance)endurance2).setSourceStack(chest, true);
                    this.self.method_6092(endurance2);
                }
            } else if (this.self.method_6059(EnduranceStatusEffects.ENDURANCE) && (endurance = this.self.method_6112(EnduranceStatusEffects.ENDURANCE)) instanceof IEffectInstance && EnduranceHelper.getUndyingLevel((class_1937)world, (instance = (IEffectInstance)endurance).getSourceStack()) > 0) {
                this.self.method_6016(EnduranceStatusEffects.ENDURANCE);
            }
        }
    }

    @Inject(method={"method_37222(Lnet/minecraft/class_1293;Lnet/minecraft/class_1297;)Z"}, at={@At(value="RETURN")})
    private void applyVulnerability(class_1293 effect, class_1297 source, CallbackInfoReturnable<Boolean> info) {
        class_1324 instance;
        if (EnduranceHelper.isDeepWound(effect) && !(this.self instanceof class_1657) && (instance = this.self.method_5996(DuskyWispAttributes.VULNERABILITY)) != null) {
            float amp = 0.15f * (float)(effect.method_5578() + 1);
            instance.method_61163(new class_1322(Endurance.id("effect.deep_wound.non_player"), (double)amp, class_1322.class_1323.field_6328));
        }
        if (((Boolean)info.getReturnValue()).booleanValue() && effect instanceof IEffectInstance) {
            IEffectInstance instance1 = (IEffectInstance)effect;
            instance1.setEntity(this.self);
        }
    }

    @Inject(method={"method_6025(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void recoverDeepWound(float amount, CallbackInfo info) {
        IPlayerEntity player;
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof IPlayerEntity && (player = (IPlayerEntity)class_13092).hasDeepWound()) {
            player.addMP(amount * player.getHealRate());
            info.cancel();
        }
    }

    @Inject(method={"method_6129(Ljava/util/Collection;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1291;method_5562(Lnet/minecraft/class_5131;)V", shift=At.Shift.AFTER)})
    private void removeDeepWound(Collection<class_1293> effects, CallbackInfo info, @Local class_1293 instance) {
        if (!EnduranceHelper.isDeepWound(instance)) {
            return;
        }
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof IPlayerEntity) {
            IPlayerEntity player = (IPlayerEntity)class_13092;
            player.onRemovedDeepWound();
        } else {
            class_1324 vulnerability = this.self.method_5996(DuskyWispAttributes.VULNERABILITY);
            if (vulnerability != null) {
                vulnerability.method_6200(Endurance.id("effect.deep_wound.non_player"));
            }
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void save(class_11372 view, CallbackInfo info) {
        HashMap<class_6880, class_1799> map = HashMap.newHashMap(0);
        ArrayList<class_6880> list = new ArrayList<class_6880>();
        for (class_1293 effect : this.self.method_6026()) {
            if (!(effect instanceof IEffectInstance)) continue;
            IEffectInstance instance = (IEffectInstance)effect;
            class_1799 stack = instance.getSourceStack();
            if (!stack.method_7960()) {
                map.put(effect.method_5579(), stack);
            }
            if (!instance.isFromEndurance()) continue;
            list.add(effect.method_5579());
        }
        view.method_71468("endurance:effect_with_source_stack", ITEM_MAP_CODEC, map);
        view.method_71468("endurance:effect_from_endurance", class_7923.field_41174.method_40294().listOf(), list);
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void read(class_11368 view, CallbackInfo info) {
        HashMap map = view.method_71426("endurance:effect_with_source_stack", ITEM_MAP_CODEC).orElse(HashMap.newHashMap(0));
        for (Map.Entry entry : map.entrySet()) {
            class_1293 class_12932 = this.self.method_6112((class_6880)entry.getKey());
            if (!(class_12932 instanceof IEffectInstance)) continue;
            IEffectInstance instance = (IEffectInstance)class_12932;
            instance.setEntity(this.self);
            instance.setSourceStack((class_1799)entry.getValue(), false);
        }
        List list = view.method_71426("endurance:effect_from_endurance", class_7923.field_41174.method_40294().listOf()).orElse(new ArrayList());
        for (class_6880 effect : list) {
            class_1293 class_12933 = this.self.method_6112(effect);
            if (!(class_12933 instanceof IEffectInstance)) continue;
            IEffectInstance instance = (IEffectInstance)class_12933;
            instance.setFromEndurance();
        }
    }
}

