/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.theblackcat.duskywisplibrary.data_component_types.Cooldown;
import net.theblackcat.duskywisplibrary.helpers.DuskyWispItemHelper;
import net.theblackcat.endurance.damage_types.EnduranceDamageTypes;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.enchantments.EnduranceEnchantmentEffects;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IEffectInstance;
import net.theblackcat.endurance.interfaces.IPlayerEntity;
import net.theblackcat.endurance.potions.EndurancePotions;
import net.theblackcat.endurance.status_effects.EnduranceStatusEffects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endurance
implements ModInitializer {
    public static final String MOD_ID = "endurance";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"endurance");

    public void onInitialize() {
        EnduranceStatusEffects.initialise();
        EnduranceDamageTypes.initialise();
        EnduranceEnchantmentEffects.initialise();
        EnduranceDataComponents.initialise();
        EndurancePotions.initialise();
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, source, amount) -> {
            class_1657 player;
            class_1937 patt0$temp;
            class_1293 endurance = entity.method_6112(EnduranceStatusEffects.ENDURANCE);
            if (endurance != null && !entity.method_6059(EnduranceStatusEffects.DEEP_WOUND)) {
                int level;
                class_1799 chest;
                IEffectInstance instance;
                if (endurance instanceof IEffectInstance && (instance = (IEffectInstance)endurance).getSourceStack().method_31573(class_3489.field_48301) && !(chest = entity.method_6118(class_1304.field_6174)).method_7960() && (level = EnduranceHelper.getUndyingLevel(entity.method_37908(), chest)) > 0) {
                    int cooldown = 3000 - (level - 1) * 600;
                    chest.method_57379(EnduranceDataComponents.UNDYING_COOLDOWN, (Object)Cooldown.of((class_1937)entity.method_37908(), (int)cooldown));
                    chest.method_7956(EnduranceHelper.getUndyingDamage(entity.method_37908(), chest), (class_3218)entity.method_37908(), null, item -> {});
                }
                entity.method_6033(1.0f);
                entity.method_6016(EnduranceStatusEffects.ENDURANCE);
                class_1293 deepWound = new class_1293(EnduranceStatusEffects.DEEP_WOUND, -1, endurance.method_5578(), false, true, true);
                entity.method_6092(deepWound);
                ((IEffectInstance)deepWound).setFromEndurance();
                return false;
            }
            if (entity instanceof class_1657 && (patt0$temp = (player = (class_1657)entity).method_37908()) instanceof class_3218) {
                class_3218 world = (class_3218)patt0$temp;
                int token = 0;
                int maxLvl = 0;
                float damage = 0.0f;
                for (class_1799 stack : DuskyWispItemHelper.forEachItem((class_1657)player)) {
                    int lvl;
                    if (stack.method_7960() || (lvl = EnduranceHelper.getBorrowedLifeLevel((class_1937)world, stack)) <= 0 || !((Cooldown)stack.method_58695(EnduranceDataComponents.BORROWED_LIFE_COOLDOWN, (Object)Cooldown.EMPTY)).isExpired((class_1937)world)) continue;
                    damage += 4.0f + (float)(lvl - 1);
                    token += 3 + (lvl - 1);
                    stack.method_57379(EnduranceDataComponents.BORROWED_LIFE_COOLDOWN, (Object)Cooldown.of((class_1937)world, (int)(1200 * (5 - (lvl - 1)))));
                    if (maxLvl >= lvl) continue;
                    maxLvl = lvl;
                }
                if (token > 0) {
                    for (class_1309 nearby : world.method_8390(class_1309.class, player.method_5829().method_1014(12.0), e -> {
                        class_1308 mob;
                        class_1321 tameable;
                        return e.method_5805() && !e.equals((Object)player) && (!(e instanceof class_1321) || !player.equals((Object)(tameable = (class_1321)e).method_35057())) && !e.method_5722((class_1297)player) && e.method_5739((class_1297)player) <= 12.0f && e instanceof class_1308 && player.equals((Object)(mob = (class_1308)e).method_5968());
                    })) {
                        nearby.method_64397(world, EnduranceDamageTypes.borrowedLife((class_1937)world, (class_1297)player, (class_1297)player), damage);
                    }
                    player.method_6033(1.0f);
                    player.method_6016(EnduranceStatusEffects.DEEP_WOUND);
                    player.method_6092(new class_1293(EnduranceStatusEffects.DEEP_WOUND, -1, maxLvl - 1, false, true, true));
                    ((IPlayerEntity)player).addMP(Math.min(15.0f, (float)token));
                    return false;
                }
            }
            return true;
        });
        FabricBrewingRecipeRegistryBuilder.BUILD.register(EndurancePotions::buildRecipe);
    }

    public static class_2960 id(String id) {
        return class_2960.method_60655((String)MOD_ID, (String)id);
    }
}

