/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_9848;
import net.theblackcat.duskywisplibrary.data_component_types.Cooldown;
import net.theblackcat.endurance.Endurance;
import net.theblackcat.endurance.config.EnduranceConfig;
import net.theblackcat.endurance.data_components.EnduranceDataComponents;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IPlayerEntity;

public class EnduranceClient
implements ClientModInitializer {
    private static final class_2960 BLOOD_VIGNETTE = class_2960.method_60656((String)"textures/misc/vignette.png");
    private class_310 client;
    private float currentAlpha = 0.0f;
    private float targetAlpha = 0.0f;
    private float finalAlpha = 0.0f;

    public void onInitializeClient() {
        this.client = class_310.method_1551();
        ItemTooltipCallback.EVENT.register((stack, context, type, list) -> {
            int cd;
            boolean spaced = false;
            if (stack.method_31573(class_3489.field_48296)) {
                boolean breaks = EnduranceClient.breaksOnNextUndying(stack);
                int cd2 = ((Cooldown)stack.method_58695(EnduranceDataComponents.UNDYING_COOLDOWN, (Object)Cooldown.EMPTY)).getCooldown((class_1937)this.client.field_1687);
                if (cd2 > 0 || breaks) {
                    spaced = true;
                    list.add(class_2561.method_43473());
                    if (cd2 > 0) {
                        list.add(EnduranceClient.getCooldown(cd2, "undying_cooldown"));
                    } else {
                        list.add(class_2561.method_43471((String)"item.endurance.undying.will_break.tooltip").method_27692(class_124.field_1061));
                    }
                }
            }
            if ((cd = ((Cooldown)stack.method_58695(EnduranceDataComponents.BORROWED_LIFE_COOLDOWN, (Object)Cooldown.EMPTY)).getCooldown((class_1937)this.client.field_1687)) > 0) {
                if (!spaced) {
                    list.add(class_2561.method_43473());
                }
                list.add(EnduranceClient.getCooldown(cd, "borrowed_life_cooldown"));
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, access) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"endurance").then(ClientCommandManager.literal((String)"showVignette").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            try {
                EnduranceConfig.Instance().SetShowVignette(enabled);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Showing vignette is " + (enabled ? "enabled" : "disabled"))));
            return 1;
        })))));
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.HOTBAR, (class_2960)Endurance.id("blood_vignette"), (context, tickCounter) -> {
            class_310 client = class_310.method_1551();
            try {
                class_746 patt0$temp = client.field_1724;
                if (patt0$temp instanceof IPlayerEntity) {
                    IPlayerEntity player = (IPlayerEntity)patt0$temp;
                    if (EnduranceConfig.Instance().ShouldShowVignette() && (player.getInjuredTime() > 0 || player.getRemovedInjuriesTime() > 0 && player.getRemovedInjuriesTime() < 30)) {
                        float smoothing;
                        float rawAlpha;
                        if (player.hasDeepWound()) {
                            rawAlpha = class_3532.method_16439((float)Math.clamp((float)player.getInjuredTime() / 10.0f, 0.0f, 1.0f), (float)0.0f, (float)0.25f);
                            rawAlpha += class_3532.method_16439((float)(player.getBP() / 20.0f), (float)0.45f, (float)0.0f);
                            smoothing = 0.05f;
                        } else {
                            rawAlpha = class_3532.method_16439((float)Math.clamp((float)player.getRemovedInjuriesTime() / 30.0f, 0.0f, 1.0f), (float)this.finalAlpha, (float)0.0f);
                            smoothing = 0.15f;
                        }
                        this.targetAlpha = rawAlpha;
                        this.currentAlpha += (this.targetAlpha - this.currentAlpha) * smoothing;
                        int i = class_9848.method_61324((int)((int)(this.currentAlpha * 255.0f)), (int)136, (int)8, (int)8);
                        context.method_25291(class_10799.field_56883, BLOOD_VIGNETTE, 0, 0, 0.0f, 0.0f, context.method_51421(), context.method_51443(), context.method_51421(), context.method_51443(), i);
                        this.finalAlpha = this.currentAlpha;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static class_5250 getCooldown(int cooldown, String key) {
        float totalSec = (float)cooldown / 20.0f;
        int min = (int)(totalSec / 60.0f);
        int sec = (int)(totalSec % 60.0f);
        Object secStr = sec < 10 ? "0" + sec : String.valueOf(sec);
        return class_2561.method_43469((String)("item.endurance." + key + ".tooltip"), (Object[])new Object[]{min, secStr}).method_27692(class_124.field_1063);
    }

    private static boolean breaksOnNextUndying(class_1799 stack) {
        return stack.method_7919() + EnduranceHelper.getUndyingDamage((class_1937)class_310.method_1551().field_1687, stack) >= stack.method_7936();
    }
}

