/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class EnduranceConfig {
    private boolean showVignette = true;
    private static EnduranceConfig instance;

    public EnduranceConfig() throws IOException {
        if (EnduranceConfig.GetFile().createNewFile()) {
            this.Save();
        } else {
            this.Read();
        }
    }

    public boolean ShouldShowVignette() {
        return this.showVignette;
    }

    public void SetShowVignette(boolean show) {
        this.showVignette = show;
    }

    public static EnduranceConfig Instance() throws IOException {
        if (instance == null) {
            instance = new EnduranceConfig();
        }
        return instance;
    }

    private static File GetFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("endurance-config.txt").toFile();
    }

    private void Save() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(EnduranceConfig.GetFile()), StandardCharsets.UTF_8));){
            writer.write(String.valueOf(this.showVignette));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void Read() {
        try (BufferedReader reader = new BufferedReader(new FileReader(EnduranceConfig.GetFile()));){
            this.showVignette = Boolean.parseBoolean(reader.readLine());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

