/*
 * Decompiled with CFR 0.152.
 */
package net.theblackcat.endurance.mixin;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.theblackcat.endurance.Endurance;
import net.theblackcat.endurance.damage_types.EnduranceDamageTypes;
import net.theblackcat.endurance.helpers.EnduranceHelper;
import net.theblackcat.endurance.interfaces.IEffectInstance;
import net.theblackcat.endurance.interfaces.IPlayerEntity;
import net.theblackcat.endurance.status_effects.EnduranceStatusEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements IPlayerEntity {
    @Unique
    private static final class_2940<Float> TEMPORARY_HEALTH = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Float> MENDING_PROGRESS = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Integer> PAUSE_DEDUCTION_TICK = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);
    @Unique
    private float tickToBleed = 0.0f;
    @Unique
    private int tickToMend = 0;
    @Unique
    private int tickToLoseMend = 0;
    @Unique
    private int damagedWhileDeepWoundTime = 0;
    @Unique
    private int appliedDeepWoundTime = 0;
    @Unique
    private int removedDeepWoundTime = 0;
    @Unique
    private class_243 prevPos = class_243.field_1353;
    @Unique
    private class_1657 self;

    @Inject(method={"<init>(Lnet/minecraft/class_1937;Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void construct(class_1937 world, GameProfile profile, CallbackInfo info) {
        this.self = (class_1657)this;
    }

    @Inject(method={"method_5693(Lnet/minecraft/class_2945$class_9222;)V"}, at={@At(value="TAIL")})
    private void initCustomData(class_2945.class_9222 builder, CallbackInfo info) {
        builder.method_56912(TEMPORARY_HEALTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(MENDING_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(PAUSE_DEDUCTION_TICK, (Object)0);
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo info) {
        class_1937 class_19372 = this.self.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (this.hasDeepWound()) {
                if (this.getData(PAUSE_DEDUCTION_TICK) <= 0) {
                    boolean bl = this.self.method_5624() || this.self.method_6030().method_7976() == class_1839.field_8950 || this.self.method_6030().method_7976() == class_1839.field_8946;
                    float deduct = bl ? 0.4f : 1.0f;
                    deduct = this.damagedWhileDeepWoundTime > 0 ? deduct * 1.5f : deduct;
                    this.tickToBleed -= deduct;
                    if (this.tickToBleed <= 0.0f) {
                        this.setBP(this.getBP() - 1.0f);
                        this.tickToBleed = this.getTimeRequiredToBleed();
                    }
                } else {
                    this.incrementInt(PAUSE_DEDUCTION_TICK, -1);
                }
                if (this.getBP() < 1.0f) {
                    this.setBP(0.0f);
                    this.self.method_64397(world, EnduranceDamageTypes.deepWound((class_1937)world, (class_1297)this.self, (class_1297)this.self), Float.MAX_VALUE);
                }
                if (this.canRecoverDeepWound()) {
                    ++this.tickToMend;
                    if (this.tickToMend >= this.getTimeRequiredToMend()) {
                        this.addMP(1.0f);
                        this.tickToMend = 0;
                    }
                } else {
                    this.tickToMend = 0;
                }
                if (this.tickToLoseMend > 0) {
                    --this.tickToLoseMend;
                    if (this.tickToLoseMend <= 0) {
                        this.addMP(-1.0f);
                        this.tickToLoseMend = 10;
                    }
                }
                this.prevPos = this.self.method_19538();
            }
        } else if (this.hasDeepWound()) {
            this.removedDeepWoundTime = 0;
            ++this.appliedDeepWoundTime;
        } else if (this.removedDeepWoundTime < 30) {
            ++this.removedDeepWoundTime;
        }
    }

    @Inject(method={"method_7324(Lnet/minecraft/class_1297;)V"}, at={@At(value="TAIL")})
    private void pauseOnAttacked(class_1297 target, CallbackInfo info) {
        if (!(target instanceof class_1296)) {
            this.pauseBleeding();
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="RETURN")})
    private void pauseOnDamaged(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source.method_5529() != null && ((Boolean)info.getReturnValue()).booleanValue()) {
            this.pauseBleeding();
        }
    }

    @Inject(method={"method_6074(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1657;method_6036(Lnet/minecraft/class_1282;F)F", shift=At.Shift.AFTER)}, cancellable=true)
    private void damageDeepWound(class_3218 world, class_1282 source, float amount, CallbackInfo info) {
        class_1293 deepWound = this.self.method_6112(EnduranceStatusEffects.DEEP_WOUND);
        if (deepWound != null && !source.method_49708(EnduranceDamageTypes.DEEP_WOUND)) {
            this.incrementFloat(TEMPORARY_HEALTH, -amount);
            if (this.isDeepWoundFromEndurance(deepWound)) {
                if (this.damagedWhileDeepWoundTime == 1) {
                    this.incrementFloat(TEMPORARY_HEALTH, -(this.getBP() * 0.25f));
                } else if (this.damagedWhileDeepWoundTime == 2) {
                    this.setBP(0.0f);
                }
                ++this.damagedWhileDeepWoundTime;
            }
            info.cancel();
        }
    }

    @Inject(method={"method_6074(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)V"}, at={@At(value="TAIL")})
    private void removeShield(class_3218 world, class_1282 source, float amount, CallbackInfo info) {
        if (this.self.method_6067() <= 0.0f) {
            this.self.method_5996(class_5134.field_45124).method_6200(Endurance.id("effect.deep_wound.removed"));
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void save(class_11372 view, CallbackInfo info) {
        view.method_71464("temp_hp", this.getBP());
        view.method_71464("healed_temp_hp", (float)this.getMP());
        view.method_71465("pause_deduction", this.getData(PAUSE_DEDUCTION_TICK).intValue());
        view.method_71464("tick_to_deduction", this.tickToBleed);
        view.method_71465("tick_to_recover", this.tickToMend);
        view.method_71465("tick_to_lose_mend", this.tickToLoseMend);
        view.method_71465("damaged_while_deep_wound", this.damagedWhileDeepWoundTime);
        view.method_71468("prev_pos", class_243.field_38277, (Object)this.prevPos);
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void read(class_11368 view, CallbackInfo info) {
        this.setBP(view.method_71423("temp_hp", 0.0f));
        this.setData(MENDING_PROGRESS, Float.valueOf(view.method_71423("healed_temp_hp", 0.0f)));
        this.setData(PAUSE_DEDUCTION_TICK, view.method_71424("pause_deduction", 0));
        this.tickToBleed = view.method_71423("tick_to_deduction", 0.0f);
        this.tickToMend = view.method_71424("tick_to_recover", 0);
        this.tickToLoseMend = view.method_71424("tick_to_lose_mend", 0);
        this.damagedWhileDeepWoundTime = view.method_71424("damaged_while_deep_wound", 0);
        this.prevPos = view.method_71426("prev_pos", class_243.field_38277).orElse(class_243.field_1353);
    }

    @Override
    public void onAppliedDeepWound() {
        List<class_1293> effects = List.copyOf(this.self.method_6026());
        for (class_1293 effect : effects) {
            if (EnduranceHelper.isDeepWound(effect)) continue;
            this.self.method_6016(effect.method_5579());
        }
        this.self.method_5996(class_5134.field_45124).method_6203();
        this.self.method_6073(0.0f);
        this.setBP(20.0f);
        this.setData(MENDING_PROGRESS, Float.valueOf(0.0f));
        this.tickToBleed = this.getTimeRequiredToBleed();
        this.setData(PAUSE_DEDUCTION_TICK, 0);
        this.tickToMend = 0;
        this.tickToLoseMend = 0;
        this.damagedWhileDeepWoundTime = 0;
    }

    @Override
    public void onRemovedDeepWound() {
        if (this.getBP() > 0.0f && this.self.method_6032() > this.getBP()) {
            this.self.method_6033(this.getBP());
        }
    }

    @Override
    public float getBP() {
        return this.getData(TEMPORARY_HEALTH).floatValue();
    }

    @Override
    public void setBP(float thp) {
        this.setData(TEMPORARY_HEALTH, Float.valueOf(Math.clamp(thp, 0.0f, 20.0f)));
    }

    @Override
    public void addMP(float thp) {
        this.setData(MENDING_PROGRESS, Float.valueOf(Math.clamp(this.getData(MENDING_PROGRESS).floatValue() + thp, 0.0f, 20.0f)));
        if (this.getMP() >= 20) {
            this.removeDeepWound();
        } else if (thp > 0.0f) {
            this.tickToLoseMend = 100;
            this.pauseBleeding();
        } else if (this.getMP() <= 0) {
            this.tickToLoseMend = 0;
        }
    }

    @Override
    public boolean lossPaused() {
        return this.hasDeepWound() && this.getData(PAUSE_DEDUCTION_TICK) > 0;
    }

    @Override
    public boolean hasDeepWound() {
        return this.self.method_68876() != null && this.self.method_68876().method_8388() && this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND);
    }

    @Override
    public float getHealRate() {
        return this.self.method_5715() ? 1.2f : 0.75f;
    }

    @Override
    public int getMP() {
        return Math.round(this.getData(MENDING_PROGRESS).floatValue());
    }

    @Override
    public int getInjuredTime() {
        return this.appliedDeepWoundTime;
    }

    @Override
    public int getRemovedInjuriesTime() {
        return this.removedDeepWoundTime;
    }

    @Unique
    private boolean isDeepWoundFromEndurance(class_1293 instance) {
        IEffectInstance instance1;
        return EnduranceHelper.isDeepWound(instance) && instance instanceof IEffectInstance && (instance1 = (IEffectInstance)instance).isFromEndurance();
    }

    @Unique
    private int getTimeRequiredToBleed() {
        if (!this.hasDeepWound()) {
            return -1;
        }
        int lvl = this.self.method_6112(EnduranceStatusEffects.DEEP_WOUND).method_5578();
        return 20 - 2 * lvl;
    }

    @Unique
    private int getTimeRequiredToMend() {
        if (!this.hasDeepWound()) {
            return -1;
        }
        int lvl = this.self.method_6112(EnduranceStatusEffects.DEEP_WOUND).method_5578();
        return 5 - lvl;
    }

    @Unique
    private void pauseBleeding() {
        if (this.self.method_6059(EnduranceStatusEffects.DEEP_WOUND)) {
            this.setData(PAUSE_DEDUCTION_TICK, 40);
        }
    }

    @Unique
    private void removeDeepWound() {
        if (this.self.method_29504()) {
            return;
        }
        this.self.method_6016(EnduranceStatusEffects.DEEP_WOUND);
        float shield = Math.max(3.0f, this.getBP() * 0.3f);
        class_2960 id = Endurance.id("effect.deep_wound.removed");
        class_1324 instance = this.self.method_5996(class_5134.field_45124);
        if (!instance.method_6196(id) || instance.method_6199(id).comp_2449() < (double)shield) {
            instance.method_61163(new class_1322(id, (double)shield, class_1322.class_1323.field_6328));
            this.self.method_6073(this.self.method_6067() + shield);
        }
        this.setBP(0.0f);
        this.setData(MENDING_PROGRESS, Float.valueOf(0.0f));
        this.self.method_6092(new class_1293(class_1294.field_5924, 40, 3, false, true, true));
        this.self.method_6092(new class_1293(class_1294.field_5904, 40, 0, false, true, true));
    }

    @Unique
    private <T> T getData(class_2940<T> data) {
        return (T)this.self.method_5841().method_12789(data);
    }

    @Unique
    private <T> void setData(class_2940<T> data, T value) {
        this.self.method_5841().method_12778(data, value);
    }

    @Unique
    private void incrementFloat(class_2940<Float> data, float amount) {
        this.setData(data, Float.valueOf(this.getData(data).floatValue() + amount));
    }

    @Unique
    private void incrementInt(class_2940<Integer> data, int amount) {
        this.setData(data, this.getData(data) + amount);
    }

    @Unique
    private boolean canRecoverDeepWound() {
        return this.self.method_5715() && !this.isMoving();
    }

    @Unique
    private boolean isMoving() {
        return this.self.method_19538().method_1022(this.prevPos) > 0.0;
    }
}

