/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.plugin;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.source.SourceMetadata;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.fabric.FabricClassSourceLookup;
import me.lucko.spark.fabric.FabricClientCommandSender;
import me.lucko.spark.fabric.FabricPlatformInfo;
import me.lucko.spark.fabric.FabricSparkMod;
import me.lucko.spark.fabric.FabricTickHook;
import me.lucko.spark.fabric.FabricTickReporter;
import me.lucko.spark.fabric.FabricWorldInfoProvider;
import me.lucko.spark.fabric.mixin.MinecraftAccessor;
import me.lucko.spark.minecraft.plugin.MinecraftClientSparkPlugin;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7157;

public class FabricClientSparkPlugin
extends MinecraftClientSparkPlugin<FabricSparkMod, FabricClientCommandSource> {
    public static void init(FabricSparkMod mod, class_310 client) {
        FabricClientSparkPlugin plugin = new FabricClientSparkPlugin(mod, client);
        plugin.enable();
    }

    public FabricClientSparkPlugin(FabricSparkMod mod, class_310 minecraft) {
        super(mod, minecraft, ((MinecraftAccessor)minecraft).getGameThread());
    }

    @Override
    public void enable() {
        super.enable();
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onDisable);
        ClientCommandRegistrationCallback.EVENT.register(this::onCommandRegister);
    }

    private void onDisable(class_310 stoppingClient) {
        if (stoppingClient == this.minecraft) {
            this.disable();
        }
    }

    private void onCommandRegister(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ctx) {
        FabricClientSparkPlugin.registerCommands(dispatcher, this, this, "sparkc", "sparkclient");
    }

    @Override
    protected CommandSender createCommandSender(FabricClientCommandSource source) {
        return new FabricClientCommandSender(source);
    }

    public Stream<CommandSender> getCommandSenders() {
        class_634 listener = this.minecraft.method_1562();
        if (listener == null) {
            return Stream.empty();
        }
        return Stream.of(new FabricClientCommandSender(listener.method_2875()));
    }

    @Override
    public TickHook createTickHook() {
        return new FabricTickHook.Client();
    }

    @Override
    public TickReporter createTickReporter() {
        return new FabricTickReporter.Client();
    }

    @Override
    public ClassSourceLookup createClassSourceLookup() {
        return new FabricClassSourceLookup(this.createClassFinder());
    }

    @Override
    public Collection<SourceMetadata> getKnownSources() {
        return SourceMetadata.gather(FabricLoader.getInstance().getAllMods(), mod -> mod.getMetadata().getId(), mod -> mod.getMetadata().getVersion().getFriendlyString(), mod -> mod.getMetadata().getAuthors().stream().map(Person::getName).collect(Collectors.joining(", ")), mod -> mod.getMetadata().getDescription());
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new FabricWorldInfoProvider.Client(this.minecraft);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new FabricPlatformInfo(PlatformInfo.Type.CLIENT);
    }
}

