/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import java.nio.file.Path;
import me.lucko.spark.forge.plugin.ForgeClientSparkPlugin;
import me.lucko.spark.forge.plugin.ForgeServerSparkPlugin;
import me.lucko.spark.minecraft.SparkMinecraftMod;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="spark")
public class ForgeSparkMod
implements SparkMinecraftMod {
    private final ModContainer container;
    private final Path configDirectory;

    public ForgeSparkMod(FMLJavaModLoadingContext ctx) {
        this.container = ctx.getContainer();
        this.configDirectory = FMLPaths.CONFIGDIR.get().resolve(this.container.getModId());
        FMLClientSetupEvent.getBus((BusGroup)ctx.getModBusGroup()).addListener(this::clientInit);
        ctx.registerDisplayTest(IExtensionPoint.DisplayTest.IGNORE_ALL_VERSION);
        ServerAboutToStartEvent.BUS.addListener(this::serverInit);
    }

    public void clientInit(FMLClientSetupEvent e) {
        ForgeClientSparkPlugin.init(this, e);
    }

    public void serverInit(ServerAboutToStartEvent e) {
        ForgeServerSparkPlugin.init(this, e);
    }

    @Override
    public String getVersion() {
        return this.container.getModInfo().getVersion().toString();
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory;
    }
}

