/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.source.SourceMetadata;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgeClassSourceLookup;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.ForgeWorldInfoProvider;
import me.lucko.spark.minecraft.plugin.MinecraftClientSparkPlugin;
import me.lucko.spark.minecraft.sender.MinecraftClientCommandSender;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgeClientSparkPlugin
extends MinecraftClientSparkPlugin<ForgeSparkMod, CommandSourceStack> {
    private Collection<EventListener> listeners = Collections.emptyList();

    public static void init(ForgeSparkMod mod, FMLClientSetupEvent event) {
        ForgeClientSparkPlugin plugin = new ForgeClientSparkPlugin(mod, Minecraft.getInstance());
        plugin.enable();
    }

    public ForgeClientSparkPlugin(ForgeSparkMod mod, Minecraft minecraft) {
        super(mod, minecraft, minecraft.gameThread);
    }

    @Override
    public void enable() {
        super.enable();
        this.listeners = BusGroup.DEFAULT.register(MethodHandles.lookup(), (Object)this);
    }

    @Override
    public void disable() {
        super.disable();
        if (!this.listeners.isEmpty()) {
            BusGroup.DEFAULT.unregister(this.listeners);
        }
        this.listeners = Collections.emptyList();
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent e) {
        ForgeClientSparkPlugin.registerCommands(e.getDispatcher(), this, this, "sparkc", "sparkclient");
    }

    @SubscribeEvent
    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
    }

    @Override
    protected CommandSender createCommandSender(CommandSourceStack source) {
        return new MinecraftClientCommandSender(source);
    }

    public Stream<MinecraftClientCommandSender> getCommandSenders() {
        return Stream.of(new MinecraftClientCommandSender((CommandSourceStack)ClientCommandHandler.getSource()));
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook.Client();
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter.Client();
    }

    @Override
    public ClassSourceLookup createClassSourceLookup() {
        return new ForgeClassSourceLookup();
    }

    @Override
    public Collection<SourceMetadata> getKnownSources() {
        return SourceMetadata.gather(ModList.get().getMods(), IModInfo::getModId, mod -> mod.getVersion().toString(), mod -> null, IModInfo::getDescription);
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new ForgeWorldInfoProvider.Client(this.minecraft);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.CLIENT);
    }
}

