/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.source.SourceMetadata;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgeClassSourceLookup;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgeServerCommandSender;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.ForgeWorldInfoProvider;
import me.lucko.spark.minecraft.plugin.MinecraftServerSparkPlugin;
import me.lucko.spark.minecraft.sender.MinecraftServerCommandSender;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

public class ForgeServerSparkPlugin
extends MinecraftServerSparkPlugin<ForgeSparkMod> {
    private static final Permission PERMISSION_LEVEL_OWNERS = new Permission.HasCommandLevel(PermissionLevel.OWNERS);
    private static final PermissionNode.PermissionResolver<Boolean> DEFAULT_PERMISSION_VALUE = (player, playerUUID, context) -> {
        if (player == null) {
            return false;
        }
        MinecraftServer server = player.level().getServer();
        if (server != null && server.isSingleplayerOwner(player.nameAndId())) {
            return true;
        }
        return player.permissions().hasPermission(PERMISSION_LEVEL_OWNERS);
    };
    private Map<String, PermissionNode<Boolean>> registeredPermissions = Collections.emptyMap();
    private Collection<EventListener> listeners = Collections.emptyList();

    public static void init(ForgeSparkMod mod, ServerAboutToStartEvent event) {
        ForgeServerSparkPlugin plugin = new ForgeServerSparkPlugin(mod, event.getServer());
        plugin.enable();
    }

    public ForgeServerSparkPlugin(ForgeSparkMod mod, MinecraftServer server) {
        super(mod, server);
    }

    @Override
    public void enable() {
        super.enable();
        this.listeners = BusGroup.DEFAULT.register(MethodHandles.lookup(), (Object)this);
    }

    @Override
    public void disable() {
        super.disable();
        if (!this.listeners.isEmpty()) {
            BusGroup.DEFAULT.unregister(this.listeners);
        }
        this.listeners = Collections.emptyList();
    }

    @SubscribeEvent
    public void onDisable(ServerStoppingEvent event) {
        if (event.getServer() == this.server) {
            this.disable();
        }
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes e) {
        List permissions = this.platform.getCommands().stream().map(Command::primaryAlias).collect(Collectors.toList());
        permissions.add("all");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map alreadyRegistered = e.getNodes().stream().collect(Collectors.toMap(PermissionNode::getNodeName, Function.identity()));
        for (String permission : permissions) {
            String permissionString = "spark." + permission;
            PermissionNode existing = (PermissionNode)alreadyRegistered.get(permissionString);
            if (existing != null) {
                builder.put((Object)permissionString, (Object)existing);
                continue;
            }
            PermissionNode node = new PermissionNode("spark", permission, PermissionTypes.BOOLEAN, DEFAULT_PERMISSION_VALUE, new PermissionDynamicContextKey[0]);
            e.addNodes(new PermissionNode[]{node});
            builder.put((Object)permissionString, (Object)node);
        }
        this.registeredPermissions = builder.build();
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent e) {
        this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public PermissionNode<Boolean> getPermissionNode(String permission) {
        PermissionNode<Boolean> permissionNode;
        if (permission.equals("spark")) {
            permission = "spark.all";
        }
        if ((permissionNode = this.registeredPermissions.get(permission)) == null) {
            throw new IllegalStateException("spark permission not registered: " + permission);
        }
        return permissionNode;
    }

    @Override
    protected MinecraftServerCommandSender createCommandSender(CommandSourceStack source) {
        return new ForgeServerCommandSender(source, this);
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook.Server();
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter.Server();
    }

    @Override
    public ClassSourceLookup createClassSourceLookup() {
        return new ForgeClassSourceLookup();
    }

    @Override
    public Collection<SourceMetadata> getKnownSources() {
        return SourceMetadata.gather(ModList.get().getMods(), IModInfo::getModId, mod -> mod.getVersion().toString(), mod -> null, IModInfo::getDescription);
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new ForgeWorldInfoProvider.Server(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.SERVER);
    }
}

