/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.minecraft.plugin;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.lucko.spark.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.minecraft.MinecraftPlayerPingProvider;
import me.lucko.spark.minecraft.MinecraftServerConfigProvider;
import me.lucko.spark.minecraft.SparkMinecraftMod;
import me.lucko.spark.minecraft.plugin.MinecraftSparkPlugin;
import me.lucko.spark.minecraft.sender.MinecraftServerCommandSender;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public abstract class MinecraftServerSparkPlugin<M extends SparkMinecraftMod>
extends MinecraftSparkPlugin<M>
implements Command<CommandSourceStack>,
SuggestionProvider<CommandSourceStack> {
    protected final MinecraftServer server;
    private final ThreadDumper gameThreadDumper;

    public MinecraftServerSparkPlugin(M mod, MinecraftServer server) {
        super(mod);
        this.server = server;
        this.gameThreadDumper = new ThreadDumper.Specific(server.getRunningThread());
    }

    @Override
    public void enable() {
        super.enable();
        this.registerCommands((CommandDispatcher<CommandSourceStack>)this.server.getCommands().getDispatcher());
    }

    public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        MinecraftServerSparkPlugin.registerCommands(dispatcher, this, this, "spark");
    }

    protected abstract MinecraftServerCommandSender createCommandSender(CommandSourceStack var1);

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String[] args = MinecraftServerSparkPlugin.processArgs(context, false, "/spark", "spark");
        if (args == null) {
            return 0;
        }
        this.platform.executeCommand(this.createCommandSender((CommandSourceStack)context.getSource()), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = MinecraftServerSparkPlugin.processArgs(context, true, "/spark", "spark");
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(this.createCommandSender((CommandSourceStack)context.getSource()), args, builder);
    }

    public Stream<MinecraftServerCommandSender> getCommandSenders() {
        return Stream.concat(this.server.getPlayerList().getPlayers().stream().map(ServerPlayer::createCommandSourceStack), Stream.of(this.server.createCommandSourceStack())).map(this::createCommandSender);
    }

    @Override
    public void executeSync(Runnable task) {
        this.server.executeIfPossible(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    @Override
    public PlayerPingProvider createPlayerPingProvider() {
        return new MinecraftPlayerPingProvider(this.server);
    }

    @Override
    public ServerConfigProvider createServerConfigProvider() {
        return new MinecraftServerConfigProvider();
    }

    @Override
    public String getCommandName() {
        return "spark";
    }
}

