/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.minecraft;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.gamerules.GameRule;

public abstract class MinecraftWorldInfoProvider
implements WorldInfoProvider {
    protected abstract PackRepository getPackRepository();

    @Override
    public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
        return this.getPackRepository().getSelectedPacks().stream().map(pack -> new WorldInfoProvider.DataPackInfo(pack.getId(), pack.getDescription().getString(), MinecraftWorldInfoProvider.resourcePackSource(pack.getPackSource()))).collect(Collectors.toList());
    }

    private static String resourcePackSource(PackSource source) {
        if (source == PackSource.DEFAULT) {
            return "none";
        }
        if (source == PackSource.BUILT_IN) {
            return "builtin";
        }
        if (source == PackSource.WORLD) {
            return "world";
        }
        if (source == PackSource.SERVER) {
            return "server";
        }
        return "unknown";
    }

    static final class MinecraftChunkInfo
    extends AbstractChunkInfo<EntityType<?>> {
        private final CountMap<EntityType<?>> entityCounts = new CountMap.Simple(new HashMap());

        MinecraftChunkInfo(long chunkPos) {
            super(ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos));
        }

        @Override
        public CountMap<EntityType<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(EntityType<?> type) {
            return EntityType.getKey(type).toString();
        }
    }

    public static abstract class Client
    extends MinecraftWorldInfoProvider {
        private final Minecraft client;

        public Client(Minecraft client) {
            this.client = client;
        }

        protected abstract int countEntities(ClientLevel var1);

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            int entities = this.countEntities(level);
            int chunks = level.getChunkSource().getLoadedChunksCount();
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        protected abstract Iterable<Entity> getAllEntities(ClientLevel var1);

        public WorldInfoProvider.ChunksResult<MinecraftChunkInfo> pollChunks() {
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            WorldInfoProvider.ChunksResult<MinecraftChunkInfo> data = new WorldInfoProvider.ChunksResult<MinecraftChunkInfo>();
            Long2ObjectOpenHashMap worldInfos = new Long2ObjectOpenHashMap();
            for (Entity entity : this.getAllEntities(level)) {
                MinecraftChunkInfo info = (MinecraftChunkInfo)worldInfos.computeIfAbsent(entity.chunkPosition().toLong(), MinecraftChunkInfo::new);
                info.entityCounts.increment(entity.getType());
            }
            data.put(level.dimension().identifier().getPath(), List.copyOf(worldInfos.values()));
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            return null;
        }

        @Override
        protected PackRepository getPackRepository() {
            return this.client.getResourcePackRepository();
        }
    }

    public static abstract class Server
    extends MinecraftWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        protected abstract int countEntities(ServerLevel var1);

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.getPlayerCount();
            int entities = 0;
            int chunks = 0;
            for (ServerLevel level : this.server.getAllLevels()) {
                entities += this.countEntities(level);
                chunks += level.getChunkSource().getLoadedChunksCount();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<MinecraftChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<MinecraftChunkInfo> data = new WorldInfoProvider.ChunksResult<MinecraftChunkInfo>();
            for (ServerLevel level : this.server.getAllLevels()) {
                Long2ObjectOpenHashMap worldInfos = new Long2ObjectOpenHashMap();
                for (Entity entity : level.getAllEntities()) {
                    MinecraftChunkInfo info = (MinecraftChunkInfo)worldInfos.computeIfAbsent(entity.chunkPosition().toLong(), MinecraftChunkInfo::new);
                    info.entityCounts.increment(entity.getType());
                }
                data.put(level.dimension().identifier().getPath(), List.copyOf(worldInfos.values()));
            }
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
            Iterable worlds = this.server.getAllLevels();
            for (ServerLevel level : worlds) {
                String levelName = level.dimension().identifier().getPath();
                level.getGameRules().availableRules().forEach(rule -> {
                    String defaultValue = Server.gameRuleDefaultValue(rule);
                    data.putDefault(rule.id(), defaultValue);
                    String value = level.getGameRules().getAsString(rule);
                    data.put(rule.id(), levelName, value);
                });
            }
            return data;
        }

        private static <T> String gameRuleDefaultValue(GameRule<T> rule) {
            return rule.serialize(rule.defaultValue());
        }

        @Override
        protected PackRepository getPackRepository() {
            return this.server.getPackRepository();
        }
    }
}

