/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge;

import java.lang.reflect.Method;
import me.lucko.spark.minecraft.MinecraftWorldInfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.neoforged.fml.ModList;

public class NeoForgeWorldInfoProvider {

    private static final class MoonriseMethods {
        private static Method getEntityCount;

        private MoonriseMethods() {
        }

        private static Method getEntityCountMethod(LevelEntityGetter<Entity> getter) {
            if (getEntityCount == null) {
                try {
                    getEntityCount = getter.getClass().getMethod("getEntityCount", new Class[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Cannot find Moonrise getEntityCount method", e);
                }
            }
            return getEntityCount;
        }

        private static int getEntityCount(LevelEntityGetter<Entity> getter) {
            try {
                return (Integer)MoonriseMethods.getEntityCountMethod(getter).invoke(getter, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to invoke Moonrise getEntityCount method", e);
            }
        }
    }

    public static final class Client
    extends MinecraftWorldInfoProvider.Client {
        public Client(Minecraft client) {
            super(client);
        }

        @Override
        protected int countEntities(ClientLevel level) {
            if (ModList.get().isLoaded("moonrise")) {
                return MoonriseMethods.getEntityCount((LevelEntityGetter<Entity>)level.getEntities());
            }
            TransientEntitySectionManager entityManager = level.entityStorage;
            EntityLookup entityIndex = entityManager.entityStorage;
            return entityIndex.count();
        }

        @Override
        protected Iterable<Entity> getAllEntities(ClientLevel level) {
            return level.getEntities().getAll();
        }
    }

    public static final class Server
    extends MinecraftWorldInfoProvider.Server {
        public Server(MinecraftServer server) {
            super(server);
        }

        @Override
        protected int countEntities(ServerLevel level) {
            if (ModList.get().isLoaded("moonrise")) {
                return MoonriseMethods.getEntityCount((LevelEntityGetter<Entity>)level.getEntities());
            }
            PersistentEntitySectionManager entityManager = level.entityManager;
            EntityLookup entityIndex = entityManager.visibleEntityStorage;
            return entityIndex.count();
        }
    }
}

