/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.UUID;
import me.lucko.spark.common.command.sender.AbstractCommandSender;
import me.lucko.spark.forge.plugin.ForgeServerSparkPlugin;
import me.lucko.spark.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.Entity;

public class ForgeServerCommandSender
extends AbstractCommandSender<CommandSourceStack> {
    private final ForgeServerSparkPlugin plugin;

    public ForgeServerCommandSender(CommandSourceStack commandSource, ForgeServerSparkPlugin plugin) {
        super(commandSource);
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        String name = ((CommandSourceStack)this.delegate).getTextName();
        if (((CommandSourceStack)this.delegate).getEntity() != null && name.equals("Server")) {
            return "Console";
        }
        return name;
    }

    @Override
    public UUID getUniqueId() {
        Entity entity = ((CommandSourceStack)this.delegate).getEntity();
        return entity != null ? entity.getUUID() : null;
    }

    @Override
    public void sendMessage(me.lucko.spark.lib.adventure.text.Component message) {
        Component component = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)RegistryAccess.EMPTY.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)GsonComponentSerializer.gson().serializeToTree(message)).getOrThrow(JsonParseException::new)).getFirst();
        ((CommandSourceStack)this.delegate).sendSystemMessage(component);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.plugin.hasPermission((CommandSourceStack)this.delegate, permission);
    }

    @Override
    protected Object getObjectForComparison() {
        UUID uniqueId = this.getUniqueId();
        if (uniqueId != null) {
            return uniqueId;
        }
        Entity entity = ((CommandSourceStack)this.delegate).getEntity();
        if (entity != null) {
            return entity;
        }
        return this.getName();
    }
}

