/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import me.lucko.spark.common.tick.SimpleTickReporter;
import me.lucko.spark.common.tick.TickReporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.listener.EventListener;
import org.jspecify.annotations.NonNull;

public abstract class ForgeTickReporter
extends SimpleTickReporter
implements TickReporter {
    private final EventBus<? extends @NonNull TickEvent> preBus;
    private final EventBus<? extends @NonNull TickEvent> postBus;
    private EventListener preListener;
    private EventListener postListener;

    protected ForgeTickReporter(EventBus<? extends @NonNull TickEvent> preBus, EventBus<? extends @NonNull TickEvent> postBus) {
        this.preBus = preBus;
        this.postBus = postBus;
    }

    public void onStart(TickEvent e) {
        this.onStart();
    }

    public void onEnd(TickEvent e) {
        this.onEnd();
    }

    @Override
    public void start() {
        this.preListener = this.preBus.addListener(x$0 -> this.onStart((TickEvent)x$0));
        this.postListener = this.postBus.addListener(x$0 -> this.onEnd((TickEvent)x$0));
    }

    @Override
    public void close() {
        if (this.preListener != null) {
            this.preBus.removeListener(this.preListener);
            this.preListener = null;
        }
        if (this.postListener != null) {
            this.postBus.removeListener(this.postListener);
            this.postListener = null;
        }
        super.close();
    }

    public static final class Client
    extends ForgeTickReporter {
        public Client() {
            super((EventBus<? extends TickEvent>)TickEvent.ClientTickEvent.Pre.BUS, (EventBus<? extends TickEvent>)TickEvent.ClientTickEvent.Post.BUS);
        }
    }

    public static final class Server
    extends ForgeTickReporter {
        public Server() {
            super((EventBus<? extends TickEvent>)TickEvent.ServerTickEvent.Pre.BUS, (EventBus<? extends TickEvent>)TickEvent.ServerTickEvent.Post.BUS);
        }
    }
}

