/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgePlayerPingProvider;
import me.lucko.spark.forge.ForgeServerCommandSender;
import me.lucko.spark.forge.ForgeServerConfigProvider;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.ForgeWorldInfoProvider;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

public class ForgeServerSparkPlugin
extends ForgeSparkPlugin
implements com.mojang.brigadier.Command<CommandSourceStack>,
SuggestionProvider<CommandSourceStack> {
    private static final PermissionNode.PermissionResolver<Boolean> DEFAULT_PERMISSION_VALUE = (player, playerUUID, context) -> {
        if (player == null) {
            return false;
        }
        MinecraftServer server = player.level().getServer();
        if (server != null && server.isSingleplayerOwner(player.nameAndId())) {
            return true;
        }
        return player.hasPermissions(4);
    };
    private final MinecraftServer server;
    private final ThreadDumper gameThreadDumper;
    private Map<String, PermissionNode<Boolean>> registeredPermissions = Collections.emptyMap();
    private Collection<EventListener> listeners = Collections.emptyList();

    public static void register(ForgeSparkMod mod, ServerAboutToStartEvent event) {
        ForgeServerSparkPlugin plugin = new ForgeServerSparkPlugin(mod, event.getServer());
        plugin.enable();
    }

    public ForgeServerSparkPlugin(ForgeSparkMod mod, MinecraftServer server) {
        super(mod);
        this.server = server;
        this.gameThreadDumper = new ThreadDumper.Specific(server.getRunningThread());
    }

    @Override
    public void enable() {
        super.enable();
        this.registerCommands((CommandDispatcher<CommandSourceStack>)this.server.getCommands().getDispatcher());
        this.listeners = BusGroup.DEFAULT.register(MethodHandles.lookup(), (Object)this);
    }

    @Override
    public void disable() {
        super.disable();
        if (!this.listeners.isEmpty()) {
            BusGroup.DEFAULT.unregister(this.listeners);
        }
        this.listeners = Collections.emptyList();
    }

    @SubscribeEvent
    public void onDisable(ServerStoppingEvent event) {
        if (event.getServer() == this.server) {
            this.disable();
        }
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes e) {
        List permissions = this.platform.getCommands().stream().map(Command::primaryAlias).collect(Collectors.toList());
        permissions.add("all");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map alreadyRegistered = e.getNodes().stream().collect(Collectors.toMap(PermissionNode::getNodeName, Function.identity()));
        for (String permission : permissions) {
            String permissionString = "spark." + permission;
            PermissionNode existing = (PermissionNode)alreadyRegistered.get(permissionString);
            if (existing != null) {
                builder.put((Object)permissionString, (Object)existing);
                continue;
            }
            PermissionNode node = new PermissionNode("spark", permission, PermissionTypes.BOOLEAN, DEFAULT_PERMISSION_VALUE, new PermissionDynamicContextKey[0]);
            e.addNodes(new PermissionNode[]{node});
            builder.put((Object)permissionString, (Object)node);
        }
        this.registeredPermissions = builder.build();
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent e) {
        this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        ForgeServerSparkPlugin.registerCommands(dispatcher, this, this, "spark");
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String[] args = ForgeServerSparkPlugin.processArgs(context, false, "/spark", "spark");
        if (args == null) {
            return 0;
        }
        this.platform.executeCommand(new ForgeServerCommandSender((CommandSourceStack)context.getSource(), this), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = ForgeServerSparkPlugin.processArgs(context, true, "/spark", "spark");
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new ForgeServerCommandSender((CommandSourceStack)context.getSource(), this), args, builder);
    }

    public boolean hasPermission(CommandSourceStack stack, String permission) {
        ServerPlayer player = stack.getPlayer();
        if (player != null) {
            PermissionNode<Boolean> permissionNode;
            if (permission.equals("spark")) {
                permission = "spark.all";
            }
            if ((permissionNode = this.registeredPermissions.get(permission)) == null) {
                throw new IllegalStateException("spark permission not registered: " + permission);
            }
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, permissionNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        }
        return true;
    }

    public Stream<ForgeServerCommandSender> getCommandSenders() {
        return Stream.concat(this.server.getPlayerList().getPlayers().stream().map(ServerPlayer::createCommandSourceStack), Stream.of(this.server.createCommandSourceStack())).map(stack -> new ForgeServerCommandSender((CommandSourceStack)stack, this));
    }

    @Override
    public void executeSync(Runnable task) {
        this.server.executeIfPossible(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook.Server();
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter.Server();
    }

    @Override
    public PlayerPingProvider createPlayerPingProvider() {
        return new ForgePlayerPingProvider(this.server);
    }

    @Override
    public ServerConfigProvider createServerConfigProvider() {
        return new ForgeServerConfigProvider();
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new ForgeWorldInfoProvider.Server(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.SERVER);
    }

    @Override
    public String getCommandName() {
        return "spark";
    }
}

